/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.renderkit.renderer;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.List;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.application.TobagoFacesMessage;
import org.apache.myfaces.tobago.internal.component.AbstractUIMessages;
import org.apache.myfaces.tobago.internal.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.renderkit.RendererBase;
import org.apache.myfaces.tobago.renderkit.css.BootstrapClass;
import org.apache.myfaces.tobago.renderkit.html.Arias;
import org.apache.myfaces.tobago.renderkit.html.DataAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlButtonTypes;
import org.apache.myfaces.tobago.renderkit.html.HtmlElements;
import org.apache.myfaces.tobago.renderkit.html.HtmlInputTypes;
import org.apache.myfaces.tobago.renderkit.html.HtmlRoleValues;
import org.apache.myfaces.tobago.renderkit.html.MarkupLanguageAttributes;
import org.apache.myfaces.tobago.util.ResourceUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessagesRenderer<T extends AbstractUIMessages>
extends RendererBase<T> {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Override
    public void encodeEndInternal(FacesContext facesContext, T component) throws IOException {
        if (((AbstractUIMessages)component).isConfirmation()) {
            LOG.warn("'confirmation' is currently not supported for tc:messages!");
        }
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        if (LOG.isDebugEnabled()) {
            LOG.debug("facesContext is " + facesContext.getClass().getName());
        }
        List<AbstractUIMessages.Item> messageList = ((AbstractUIMessages)component).createMessageList(facesContext);
        writer.startElement(HtmlElements.TOBAGO_MESSAGES);
        writer.writeIdAttribute(component.getClientId(facesContext));
        writer.writeClassAttribute(component.getCustomClass());
        FacesMessage.Severity lastSeverity = null;
        boolean first = true;
        for (AbstractUIMessages.Item item : messageList) {
            FacesMessage message = item.getFacesMessage();
            FacesMessage.Severity severity = message.getSeverity();
            if (!first && lastSeverity != severity) {
                writer.endElement(HtmlElements.DIV);
            }
            if (first || lastSeverity != severity) {
                writer.startElement(HtmlElements.DIV);
                writer.writeClassAttribute(BootstrapClass.ALERT, BootstrapClass.ALERT_DISMISSIBLE, BootstrapClass.alert(severity), BootstrapClass.FADE, BootstrapClass.SHOW);
                HtmlRendererUtils.writeDataAttributes(facesContext, writer, component);
                if (message instanceof TobagoFacesMessage) {
                    TobagoFacesMessage tobagoFacesMessage = (TobagoFacesMessage)message;
                    HtmlRendererUtils.writeDataAttributes(facesContext, writer, tobagoFacesMessage.getDataAttributes());
                }
                writer.writeAttribute(HtmlAttributes.ROLE, HtmlRoleValues.ALERT.toString(), false);
                writer.startElement(HtmlElements.BUTTON);
                writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TYPE, HtmlButtonTypes.BUTTON);
                writer.writeClassAttribute(BootstrapClass.BTN_CLOSE);
                writer.writeAttribute(DataAttributes.BS_DISMISS, "alert", false);
                writer.writeAttribute(Arias.LABEL, ResourceUtils.getString(facesContext, "alert.close"), false);
                writer.endElement(HtmlElements.BUTTON);
            }
            this.encodeMessage(writer, (AbstractUIMessages)component, message, item.getForId());
            lastSeverity = severity;
            first = false;
        }
        if (messageList.size() > 0) {
            writer.endElement(HtmlElements.DIV);
        }
        if (component.getFor() == null) {
            String id = component.getClientId(facesContext) + "::messagesExists";
            writer.startElement(HtmlElements.INPUT);
            writer.writeAttribute(HtmlAttributes.VALUE, Boolean.TRUE.toString(), false);
            writer.writeAttribute(HtmlAttributes.ID, id, false);
            writer.writeAttribute(HtmlAttributes.NAME, id, false);
            writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TYPE, HtmlInputTypes.HIDDEN);
            writer.endElement(HtmlElements.INPUT);
        }
        writer.endElement(HtmlElements.TOBAGO_MESSAGES);
    }

    private void encodeMessage(TobagoResponseWriter writer, AbstractUIMessages messages, FacesMessage message, String forId) throws IOException {
        String summary = message.getSummary();
        String detail = message.getDetail();
        boolean showSummary = summary != null && messages.isShowSummary() && summary.length() > 0;
        boolean showDetails = detail != null && messages.isShowDetail() && detail.length() > 0;
        writer.startElement(HtmlElements.LABEL);
        writer.writeAttribute(HtmlAttributes.FOR, forId, false);
        writer.writeAttribute(HtmlAttributes.TITLE, detail, true);
        if (showSummary && showDetails && !summary.equals(detail)) {
            writer.startElement(HtmlElements.STRONG);
            writer.writeText(summary);
            writer.endElement(HtmlElements.STRONG);
            writer.writeText(detail);
        } else if (showSummary) {
            writer.writeText(summary);
        } else if (showDetails) {
            writer.writeText(detail);
        } else {
            writer.writeText(message.getSeverity().toString());
        }
        writer.endElement(HtmlElements.LABEL);
        message.rendered();
    }
}

