/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.util;

import java.io.UnsupportedEncodingException;
import javax.faces.context.FacesContext;
import javax.portlet.ClientDataRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.myfaces.tobago.portlet.PortletUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RequestUtils {
    private static final Logger LOG = LoggerFactory.getLogger(RequestUtils.class);

    private RequestUtils() {
    }

    public static void ensureEncoding(FacesContext facesContext) {
        Object request = facesContext.getExternalContext().getRequest();
        try {
            ClientDataRequest portletRequest;
            if (request instanceof HttpServletRequest) {
                HttpServletRequest servletRequest = (HttpServletRequest)request;
                if (servletRequest.getCharacterEncoding() == null) {
                    servletRequest.setCharacterEncoding("UTF-8");
                }
            } else if (PortletUtils.isPortletApiAvailable() && request instanceof ClientDataRequest && (portletRequest = (ClientDataRequest)request).getCharacterEncoding() == null) {
                portletRequest.setCharacterEncoding("UTF-8");
            }
        }
        catch (UnsupportedEncodingException e) {
            LOG.error("" + e, (Throwable)e);
        }
    }
}

