/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html.standard.standard.tag;

import java.io.IOException;
import java.util.Map;
import javax.el.ValueExpression;
import javax.faces.application.Application;
import javax.faces.application.FacesMessage;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.component.UIPanel;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.event.FacesEvent;
import org.apache.myfaces.tobago.component.SupportsAccessKey;
import org.apache.myfaces.tobago.component.SupportsMarkup;
import org.apache.myfaces.tobago.component.UICommand;
import org.apache.myfaces.tobago.component.UIMenu;
import org.apache.myfaces.tobago.component.UIMenuCommand;
import org.apache.myfaces.tobago.component.UITab;
import org.apache.myfaces.tobago.component.UITabGroup;
import org.apache.myfaces.tobago.component.UIToolBar;
import org.apache.myfaces.tobago.config.Configurable;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.context.ResourceManagerUtils;
import org.apache.myfaces.tobago.event.TabChangeEvent;
import org.apache.myfaces.tobago.internal.component.AbstractUIMenu;
import org.apache.myfaces.tobago.internal.component.AbstractUIPanelBase;
import org.apache.myfaces.tobago.internal.util.AccessKeyLogger;
import org.apache.myfaces.tobago.internal.util.StringUtils;
import org.apache.myfaces.tobago.layout.LayoutBase;
import org.apache.myfaces.tobago.layout.Measure;
import org.apache.myfaces.tobago.renderkit.LabelWithAccessKey;
import org.apache.myfaces.tobago.renderkit.LayoutComponentRendererBase;
import org.apache.myfaces.tobago.renderkit.css.Classes;
import org.apache.myfaces.tobago.renderkit.css.Position;
import org.apache.myfaces.tobago.renderkit.css.Style;
import org.apache.myfaces.tobago.renderkit.html.JsonUtils;
import org.apache.myfaces.tobago.renderkit.html.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.renderkit.util.RenderUtils;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.util.CreateComponentUtils;
import org.apache.myfaces.tobago.util.FacetUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TabGroupRenderer
extends LayoutComponentRendererBase {
    private static final Logger LOG = LoggerFactory.getLogger(TabGroupRenderer.class);
    public static final String ACTIVE_INDEX_POSTFIX = "::activeIndex";

    public void decode(FacesContext facesContext, UIComponent component) {
        if (ComponentUtils.isOutputOnly((UIComponent)component)) {
            return;
        }
        int oldIndex = ((UITabGroup)component).getRenderedIndex();
        String clientId = component.getClientId(facesContext);
        Map parameters = facesContext.getExternalContext().getRequestParameterMap();
        String newValue = (String)parameters.get(clientId + ACTIVE_INDEX_POSTFIX);
        try {
            int activeIndex = Integer.parseInt(newValue);
            if (activeIndex != oldIndex) {
                TabChangeEvent event = new TabChangeEvent(component, Integer.valueOf(oldIndex), Integer.valueOf(activeIndex));
                component.queueEvent((FacesEvent)event);
            }
        }
        catch (NumberFormatException e) {
            LOG.error("Can't parse activeIndex: '" + newValue + "'");
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        UITabGroup tabGroup = (UITabGroup)uiComponent;
        int activeIndex = this.ensureRenderedActiveIndex(facesContext, tabGroup);
        String clientId = tabGroup.getClientId(facesContext);
        String hiddenId = clientId + ACTIVE_INDEX_POSTFIX;
        String switchType = tabGroup.getSwitchType();
        TobagoResponseWriter writer = HtmlRendererUtils.getTobagoResponseWriter(facesContext);
        writer.startElement("div", null);
        writer.writeIdAttribute(clientId);
        writer.writeClassAttribute(Classes.create((UIComponent)tabGroup));
        HtmlRendererUtils.writeDataAttributes(facesContext, writer, (UIComponent)tabGroup);
        writer.writeStyleAttribute(new Style(facesContext, (LayoutBase)tabGroup));
        writer.writeAttribute("switchtype", switchType, false);
        String[] clientIds = ComponentUtils.evaluateClientIds((FacesContext)facesContext, (UIComponent)tabGroup, (String[])tabGroup.getRenderedPartially());
        if (clientIds.length > 0) {
            writer.writeAttribute("data-tobago-partial-ids", JsonUtils.encode(clientIds), true);
        }
        writer.startElement("input", null);
        writer.writeAttribute("type", "hidden", false);
        writer.writeAttribute("value", activeIndex);
        writer.writeNameAttribute(hiddenId);
        writer.writeIdAttribute(hiddenId);
        writer.endElement("input");
        this.encodeHeader(facesContext, writer, tabGroup, activeIndex);
        int index = 0;
        for (UIComponent tab : tabGroup.getChildren()) {
            if (!(tab instanceof UITab)) continue;
            if (tab.isRendered() && ("client".equals(switchType) || index == activeIndex)) {
                this.encodeContent(writer, facesContext, (UITab)tab, index);
            }
            ++index;
        }
        writer.endElement("div");
    }

    private int ensureRenderedActiveIndex(FacesContext context, UITabGroup tabGroup) {
        ValueExpression expression;
        int activeIndex = tabGroup.getSelectedIndex();
        int index = -1;
        int closestRenderedTabIndex = -1;
        for (UIComponent tab : tabGroup.getChildren()) {
            ++index;
            if (!(tab instanceof AbstractUIPanelBase)) continue;
            if (index == activeIndex) {
                if (tab.isRendered()) {
                    return index;
                }
                if (closestRenderedTabIndex > -1) break;
            }
            if (!tab.isRendered()) continue;
            closestRenderedTabIndex = index;
            if (index <= activeIndex) continue;
            break;
        }
        if (closestRenderedTabIndex == -1) {
            closestRenderedTabIndex = 0;
        }
        if ((expression = tabGroup.getValueExpression("selectedIndex")) != null) {
            expression.setValue(context.getELContext(), (Object)closestRenderedTabIndex);
        } else {
            tabGroup.setSelectedIndex(Integer.valueOf(closestRenderedTabIndex));
        }
        return closestRenderedTabIndex;
    }

    private void encodeHeader(FacesContext facesContext, TobagoResponseWriter writer, UITabGroup tabGroup, int activeIndex) throws IOException {
        Measure width = tabGroup.getCurrentWidth();
        Measure headerHeight = this.getResourceManager().getThemeMeasure(facesContext, (Configurable)tabGroup, "headerHeight");
        Style header = new Style();
        header.setPosition(Position.RELATIVE);
        if (tabGroup.isShowNavigationBar()) {
            Measure toolBarWidth = this.getResourceManager().getThemeMeasure(facesContext, (Configurable)tabGroup, "toolBarWidth");
            header.setWidth(width.subtractNotNegative(toolBarWidth));
        }
        header.setHeight(headerHeight);
        writer.startElement("div", (UIComponent)tabGroup);
        writer.writeClassAttribute(Classes.create((UIComponent)tabGroup, (String)"header"));
        writer.writeStyleAttribute(header);
        writer.startElement("div", (UIComponent)tabGroup);
        writer.writeClassAttribute(Classes.create((UIComponent)tabGroup, (String)"headerInner"));
        int index = 0;
        for (UIComponent child : tabGroup.getChildren()) {
            UITab tab;
            if (child instanceof UITab && (tab = (UITab)child).isRendered()) {
                String image;
                FacesMessage.Severity maxSeverity;
                LabelWithAccessKey label = new LabelWithAccessKey((SupportsAccessKey)tab);
                boolean disabled = tab.isDisabled();
                if (activeIndex == index) {
                    ComponentUtils.addCurrentMarkup((SupportsMarkup)tab, (Markup)Markup.SELECTED);
                }
                if ((maxSeverity = ComponentUtils.getMaximumSeverityOfChildrenMessages((FacesContext)facesContext, (NamingContainer)tab)) != null) {
                    ComponentUtils.addCurrentMarkup((SupportsMarkup)tab, (Markup)ComponentUtils.markupOfSeverity((FacesMessage.Severity)maxSeverity));
                }
                writer.startElement("div", (UIComponent)tab);
                writer.writeClassAttribute(Classes.create((UIComponent)tab));
                writer.writeAttribute("tabgroupindex", index);
                String title = HtmlRendererUtils.getTitleFromTipAndMessages(facesContext, (UIComponent)tab);
                if (title != null) {
                    writer.writeAttribute("title", title, true);
                }
                writer.startElement("a", (UIComponent)tab);
                if (!disabled) {
                    writer.writeAttribute("href", "#", false);
                }
                String tabId = tab.getClientId(facesContext);
                writer.writeIdAttribute(tabId);
                if (!disabled && label.getAccessKey() != null) {
                    writer.writeAttribute("accesskey", Character.toString(label.getAccessKey().charValue()), false);
                    AccessKeyLogger.addAccessKey((FacesContext)facesContext, (Character)label.getAccessKey(), (String)tabId);
                }
                if (StringUtils.isNotEmpty((String)(image = tab.getImage()))) {
                    if (!ResourceManagerUtils.isAbsoluteResource((String)image)) {
                        image = ResourceManagerUtils.getImageOrDisabledImageWithPath((FacesContext)facesContext, (String)image, (boolean)disabled);
                    }
                    writer.startElement("img", null);
                    writer.writeAttribute("src", image, true);
                    writer.writeClassAttribute(Classes.create((UIComponent)tab, (String)(label.getLabel() != null ? "image-right-margin" : "image")));
                    writer.endElement("img");
                }
                if (label.getLabel() != null) {
                    HtmlRendererUtils.writeLabelWithAccessKey(writer, label);
                } else if (image == null) {
                    writer.writeText(Integer.toString(index + 1));
                }
                writer.endElement("a");
                UIPanel toolbar = (UIPanel)tab.getFacet("toolBar");
                if (toolbar != null) {
                    this.renderTabToolbar(facesContext, writer, tab, toolbar);
                }
                writer.endElement("div");
            }
            ++index;
        }
        writer.endElement("div");
        Style body = new Style();
        body.setWidth(width);
        body.setHeight(tabGroup.getCurrentHeight().subtract(headerHeight));
        writer.endElement("div");
        if (tabGroup.isShowNavigationBar()) {
            UIToolBar toolBar = this.createToolBar(facesContext, tabGroup);
            this.renderToolBar(facesContext, writer, tabGroup, toolBar);
        }
    }

    protected void renderTabToolbar(FacesContext facesContext, TobagoResponseWriter writer, UITab tab, UIPanel toolbar) throws IOException {
        writer.startElement("span", null);
        writer.writeClassAttribute(Classes.create((UIComponent)tab, (String)"toolBar"));
        toolbar.setRendererType("TabGroupToolBar");
        RenderUtils.encode(facesContext, (UIComponent)toolbar);
        writer.endElement("span");
    }

    private UIToolBar createToolBar(FacesContext facesContext, UITabGroup tabGroup) {
        String clientId = tabGroup.getClientId(facesContext);
        Application application = facesContext.getApplication();
        UIViewRoot viewRoot = facesContext.getViewRoot();
        UICommand previous = (UICommand)application.createComponent("org.apache.myfaces.tobago.Command");
        previous.setId(viewRoot.createUniqueId());
        previous.setRendererType(null);
        previous.getAttributes().put("image", "image/tabPrev");
        previous.setOmit(true);
        ComponentUtils.putDataAttribute((UIComponent)previous, (Object)"tobago-tabgroup-toolbar-prev", (Object)"p");
        UICommand next = (UICommand)application.createComponent("org.apache.myfaces.tobago.Command");
        next.setId(viewRoot.createUniqueId());
        next.setRendererType(null);
        next.getAttributes().put("image", "image/tabNext");
        next.setOmit(true);
        ComponentUtils.putDataAttribute((UIComponent)next, (Object)"tobago-tabgroup-toolbar-next", (Object)"n");
        UICommand all = (UICommand)CreateComponentUtils.createComponent((FacesContext)facesContext, (String)"org.apache.myfaces.tobago.Command", null, (String)viewRoot.createUniqueId());
        all.setOmit(true);
        UIMenu menu = (UIMenu)CreateComponentUtils.createComponent((FacesContext)facesContext, (String)"org.apache.myfaces.tobago.Menu", (String)"Menu", (String)viewRoot.createUniqueId());
        menu.setTransient(true);
        ComponentUtils.addCurrentMarkup((SupportsMarkup)menu, (Markup)Markup.TOP);
        FacetUtils.setDropDownMenu((UIComponent)all, (AbstractUIMenu)menu);
        int index = 0;
        for (UIComponent child : tabGroup.getChildren()) {
            if (!(child instanceof UITab)) continue;
            UITab tab = (UITab)child;
            if (tab.isRendered()) {
                UIMenuCommand entry = (UIMenuCommand)CreateComponentUtils.createComponent((FacesContext)facesContext, (String)"org.apache.myfaces.tobago.MenuCommand", (String)"MenuCommand", (String)viewRoot.createUniqueId());
                entry.setTransient(true);
                entry.setOmit(true);
                LabelWithAccessKey label = new LabelWithAccessKey((SupportsAccessKey)tab);
                if (label.getLabel() != null) {
                    entry.setLabel(label.getLabel());
                } else {
                    entry.setLabel(Integer.toString(index + 1));
                }
                if (tab.isDisabled()) {
                    entry.setDisabled(true);
                } else {
                    ComponentUtils.putDataAttribute((UIComponent)entry, (Object)"tobago-index", (Object)index);
                }
                menu.getChildren().add(entry);
            }
            ++index;
        }
        UIToolBar toolBar = (UIToolBar)application.createComponent("org.apache.myfaces.tobago.ToolBar");
        toolBar.setId(viewRoot.createUniqueId());
        toolBar.setRendererType("TabGroupToolBar");
        toolBar.setTransient(true);
        toolBar.getChildren().add(previous);
        toolBar.getChildren().add(next);
        toolBar.getChildren().add(all);
        tabGroup.getFacets().put("toolBar", toolBar);
        return toolBar;
    }

    private void renderToolBar(FacesContext facesContext, TobagoResponseWriter writer, UITabGroup tabGroup, UIToolBar toolBar) throws IOException {
        writer.startElement("div", null);
        writer.writeClassAttribute(Classes.create((UIComponent)tabGroup, (String)"toolBar"));
        RenderUtils.encode(facesContext, (UIComponent)toolBar);
        writer.endElement("div");
    }

    protected void encodeContent(TobagoResponseWriter writer, FacesContext facesContext, UITab tab, int index) throws IOException {
        if (tab.isDisabled()) {
            return;
        }
        writer.startElement("div", null);
        writer.writeClassAttribute(Classes.create((UIComponent)tab, (String)"content"));
        writer.writeIdAttribute(tab.getClientId(facesContext) + "::" + "content");
        Style style = new Style(facesContext, (LayoutBase)tab);
        Measure borderLeft = tab.getBorderLeft();
        Measure borderRight = tab.getBorderRight();
        Measure borderTop = tab.getBorderTop();
        Measure borderBottom = tab.getBorderBottom();
        style.setWidth(style.getWidth().subtract(borderLeft).subtract(borderRight));
        style.setHeight(style.getHeight().subtract(borderTop).subtract(borderBottom));
        writer.writeStyleAttribute(style);
        writer.writeAttribute("tabgroupindex", index);
        RenderUtils.encodeChildren(facesContext, (UIComponent)tab);
        writer.endElement("div");
    }
}

