/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.lifecycle.internal.concurrent;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import org.apache.maven.api.Lifecycle;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.Nullable;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.project.MavenProject;

public class BuildStep {
    public static final int CREATED = 0;
    public static final int PLANNING = 1;
    public static final int SCHEDULED = 2;
    public static final int EXECUTED = 3;
    public static final int FAILED = 4;
    public static final int SKIPPED = 5;
    public static final String PLAN = "$plan$";
    public static final String SETUP = "$setup$";
    public static final String TEARDOWN = "$teardown$";
    @Nonnull
    final MavenProject project;
    @Nonnull
    final String name;
    @Nullable
    final Lifecycle.Phase phase;
    final Map<Integer, Map<String, MojoExecution>> mojos = new TreeMap<Integer, Map<String, MojoExecution>>();
    final Collection<BuildStep> predecessors = new HashSet<BuildStep>();
    final Collection<BuildStep> successors = new HashSet<BuildStep>();
    final AtomicInteger status = new AtomicInteger();
    final AtomicBoolean skip = new AtomicBoolean();
    volatile Exception exception;

    public BuildStep(String name, MavenProject project, Lifecycle.Phase phase) {
        this.name = Objects.requireNonNull(name, "name cannot be null");
        this.project = Objects.requireNonNull(project, "project cannot be null");
        this.phase = phase;
    }

    public boolean isCreated() {
        return this.status.get() == 0;
    }

    public boolean isDone() {
        int state = this.status.get();
        return state == 3 || state == 4 || state == 5;
    }

    public Stream<BuildStep> allPredecessors() {
        return this.preds(new HashSet<BuildStep>()).stream();
    }

    private Set<BuildStep> preds(Set<BuildStep> preds) {
        if (preds.add(this)) {
            this.predecessors.forEach(n -> n.preds(preds));
        }
        return preds;
    }

    public boolean isSuccessorOf(BuildStep step) {
        return this.isSuccessorOf(new HashSet<BuildStep>(), step);
    }

    private boolean isSuccessorOf(Set<BuildStep> visited, BuildStep step) {
        if (this == step) {
            return true;
        }
        if (visited.add(this)) {
            return this.predecessors.stream().anyMatch(n -> n.isSuccessorOf(visited, step));
        }
        return false;
    }

    public void skip() {
        this.skip.set(true);
        this.mojos.clear();
    }

    public void addMojo(MojoExecution mojo, int priority) {
        if (!this.skip.get()) {
            this.mojos.computeIfAbsent(priority, k -> new LinkedHashMap()).put(mojo.getGoal() + ":" + mojo.getExecutionId(), mojo);
        }
    }

    public void executeAfter(BuildStep stepToExecuteBefore) {
        if (!this.isSuccessorOf(stepToExecuteBefore)) {
            this.predecessors.add(stepToExecuteBefore);
            stepToExecuteBefore.successors.add(this);
        }
    }

    public void executeBefore(BuildStep stepToExecuteAfter) {
        stepToExecuteAfter.executeAfter(this);
    }

    public Stream<MojoExecution> executions() {
        return this.mojos.values().stream().flatMap(m -> m.values().stream());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BuildStep that = (BuildStep)o;
        return Objects.equals(this.project, that.project) && Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.project, this.name);
    }

    public String toString() {
        return "BuildStep[project=" + this.project.getGroupId() + ":" + this.project.getArtifactId() + ", phase=" + this.name + "]";
    }
}

