/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.cling.invoker.mvnup.goals;

import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;

public final class ModelVersionUtils {
    private ModelVersionUtils() {
    }

    public static String detectModelVersion(Document pomDocument) {
        String modelVersion;
        Namespace namespace;
        Element root = pomDocument.getRootElement();
        Element modelVersionElement = root.getChild("modelVersion", namespace = root.getNamespace());
        if (modelVersionElement != null && !(modelVersion = modelVersionElement.getTextTrim()).isEmpty()) {
            return modelVersion;
        }
        String namespaceUri = namespace.getURI();
        if ("http://maven.apache.org/POM/4.1.0".equals(namespaceUri)) {
            return "4.1.0";
        }
        if ("http://maven.apache.org/POM/4.0.0".equals(namespaceUri)) {
            return "4.0.0";
        }
        return "4.0.0";
    }

    public static boolean isValidModelVersion(String modelVersion) {
        return "4.0.0".equals(modelVersion) || "4.1.0".equals(modelVersion);
    }

    public static boolean canUpgrade(String fromVersion, String toVersion) {
        if (fromVersion == null || toVersion == null) {
            return false;
        }
        return "4.0.0".equals(fromVersion) && "4.1.0".equals(toVersion);
    }

    public static boolean isEligibleForInference(String modelVersion) {
        return "4.0.0".equals(modelVersion) || "4.1.0".equals(modelVersion);
    }

    public static boolean isNewerThan410(String modelVersion) {
        if (modelVersion == null) {
            return false;
        }
        try {
            String[] parts = modelVersion.split("\\.");
            if (parts.length >= 2) {
                int major = Integer.parseInt(parts[0]);
                int minor = Integer.parseInt(parts[1]);
                if (major > 4) {
                    return true;
                }
                if (major == 4 && minor > 1) {
                    return true;
                }
                if (major == 4 && minor == 1 && parts.length > 2) {
                    int patch = Integer.parseInt(parts[2]);
                    return patch > 0;
                }
            }
        }
        catch (NumberFormatException e) {
            return false;
        }
        return false;
    }

    public static boolean isVersionGreaterOrEqual(String modelVersion, String targetVersion) {
        if (modelVersion == null || targetVersion == null) {
            return false;
        }
        if (modelVersion.equals(targetVersion)) {
            return true;
        }
        if ("4.1.0".equals(targetVersion)) {
            return "4.1.0".equals(modelVersion) || ModelVersionUtils.isNewerThan410(modelVersion);
        }
        return false;
    }

    public static void updateModelVersion(Document pomDocument, String newVersion) {
        Namespace namespace;
        Element root = pomDocument.getRootElement();
        Element modelVersionElement = root.getChild("modelVersion", namespace = root.getNamespace());
        if (modelVersionElement != null) {
            modelVersionElement.setText(newVersion);
        } else {
            Element newModelVersionElement = new Element("modelVersion", namespace);
            newModelVersionElement.setText(newVersion);
            root.addContent(0, (Content)newModelVersionElement);
        }
    }

    public static boolean removeModelVersion(Document pomDocument) {
        Namespace namespace;
        Element root = pomDocument.getRootElement();
        Element modelVersionElement = root.getChild("modelVersion", namespace = root.getNamespace());
        if (modelVersionElement != null) {
            return root.removeContent((Content)modelVersionElement);
        }
        return false;
    }

    public static String getSchemaLocationForModelVersion(String modelVersion) {
        if ("4.1.0".equals(modelVersion) || ModelVersionUtils.isNewerThan410(modelVersion)) {
            return "http://maven.apache.org/POM/4.1.0 https://maven.apache.org/xsd/maven-4.1.0.xsd";
        }
        return "http://maven.apache.org/POM/4.0.0 https://maven.apache.org/xsd/maven-4.0.0.xsd";
    }
}

