/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl.filter;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.aether.MultiRuntimeException;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.impl.RepositorySystemLifecycle;
import org.eclipse.aether.internal.impl.filter.RemoteRepositoryFilterSourceSupport;
import org.eclipse.aether.internal.impl.filter.ruletree.GroupTree;
import org.eclipse.aether.metadata.Metadata;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.spi.connector.filter.RemoteRepositoryFilter;
import org.eclipse.aether.spi.io.PathProcessor;
import org.eclipse.aether.spi.resolution.ArtifactResolverPostProcessor;
import org.eclipse.aether.util.ConfigUtils;
import org.eclipse.aether.util.repository.RepositoryIdHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Named(value="groupId")
public final class GroupIdRemoteRepositoryFilterSource
extends RemoteRepositoryFilterSourceSupport
implements ArtifactResolverPostProcessor {
    public static final String NAME = "groupId";
    private static final String CONFIG_PROPS_PREFIX = "aether.remoteRepositoryFilter.groupId.";
    public static final String CONFIG_PROP_ENABLED = "aether.remoteRepositoryFilter.groupId";
    public static final boolean DEFAULT_ENABLED = true;
    public static final String CONFIG_PROP_BASEDIR = "aether.remoteRepositoryFilter.groupId.basedir";
    public static final String LOCAL_REPO_PREFIX_DIR = ".remoteRepositoryFilters";
    public static final String CONFIG_PROP_RECORD = "aether.remoteRepositoryFilter.groupId.record";
    static final String GROUP_ID_FILE_PREFIX = "groupId-";
    static final String GROUP_ID_FILE_SUFFIX = ".txt";
    private final Logger logger = LoggerFactory.getLogger(GroupIdRemoteRepositoryFilterSource.class);
    private final RepositorySystemLifecycle repositorySystemLifecycle;
    private final PathProcessor pathProcessor;
    private final ConcurrentHashMap<RemoteRepository, GroupTree> rules;
    private final ConcurrentHashMap<RemoteRepository, Path> ruleFiles;
    private final ConcurrentHashMap<RemoteRepository, Set<String>> recordedRules;
    private final AtomicBoolean onShutdownHandlerRegistered;
    private static final RemoteRepositoryFilter.Result NOT_PRESENT_RESULT = new RemoteRepositoryFilterSourceSupport.SimpleResult(true, "GroupId file not present");

    @Inject
    public GroupIdRemoteRepositoryFilterSource(RepositorySystemLifecycle repositorySystemLifecycle, PathProcessor pathProcessor) {
        this.repositorySystemLifecycle = Objects.requireNonNull(repositorySystemLifecycle);
        this.pathProcessor = Objects.requireNonNull(pathProcessor);
        this.rules = new ConcurrentHashMap();
        this.ruleFiles = new ConcurrentHashMap();
        this.recordedRules = new ConcurrentHashMap();
        this.onShutdownHandlerRegistered = new AtomicBoolean(false);
    }

    @Override
    protected boolean isEnabled(RepositorySystemSession session) {
        return ConfigUtils.getBoolean((RepositorySystemSession)session, (boolean)true, (String[])new String[]{CONFIG_PROP_ENABLED});
    }

    private boolean isRepositoryFilteringEnabled(RepositorySystemSession session, RemoteRepository remoteRepository) {
        if (this.isEnabled(session)) {
            return ConfigUtils.getBoolean((RepositorySystemSession)session, (boolean)ConfigUtils.getBoolean((RepositorySystemSession)session, (boolean)true, (String[])new String[]{"aether.remoteRepositoryFilter.groupId.*"}), (String[])new String[]{CONFIG_PROPS_PREFIX + remoteRepository.getId()});
        }
        return false;
    }

    public RemoteRepositoryFilter getRemoteRepositoryFilter(RepositorySystemSession session) {
        if (this.isEnabled(session) && !this.isRecord(session)) {
            return new GroupIdFilter(session);
        }
        return null;
    }

    public void postProcess(RepositorySystemSession session, List<ArtifactResult> artifactResults) {
        if (this.isEnabled(session) && this.isRecord(session)) {
            if (this.onShutdownHandlerRegistered.compareAndSet(false, true)) {
                this.repositorySystemLifecycle.addOnSystemEndedHandler(this::saveRecordedLines);
            }
            for (ArtifactResult artifactResult : artifactResults) {
                RemoteRepository remoteRepository;
                if (!artifactResult.isResolved() || !(artifactResult.getRepository() instanceof RemoteRepository) || !this.isRepositoryFilteringEnabled(session, remoteRepository = (RemoteRepository)artifactResult.getRepository())) continue;
                this.ruleFile(session, remoteRepository);
                String line = "=" + artifactResult.getArtifact().getGroupId();
                this.recordedRules.computeIfAbsent(remoteRepository, k -> new TreeSet()).add(line);
                this.rules.compute(remoteRepository, (k, v) -> {
                    if (v == null || v == GroupTree.SENTINEL) {
                        v = new GroupTree("");
                    }
                    return v;
                }).loadNode(line);
            }
        }
    }

    private Path ruleFile(RepositorySystemSession session, RemoteRepository remoteRepository) {
        return this.ruleFiles.computeIfAbsent(remoteRepository, r -> this.getBasedir(session, LOCAL_REPO_PREFIX_DIR, CONFIG_PROP_BASEDIR, false).resolve(GROUP_ID_FILE_PREFIX + (String)RepositoryIdHelper.cachedIdToPathSegment((RepositorySystemSession)session).apply(remoteRepository) + GROUP_ID_FILE_SUFFIX));
    }

    private GroupTree cacheRules(RepositorySystemSession session, RemoteRepository remoteRepository) {
        return this.rules.computeIfAbsent(remoteRepository, r -> this.loadRepositoryRules(session, (RemoteRepository)r));
    }

    private GroupTree loadRepositoryRules(RepositorySystemSession session, RemoteRepository remoteRepository) {
        if (this.isRepositoryFilteringEnabled(session, remoteRepository)) {
            Path filePath = this.ruleFile(session, remoteRepository);
            if (Files.isReadable(filePath)) {
                GroupTree groupTree;
                block11: {
                    Stream<String> lines = Files.lines(filePath, StandardCharsets.UTF_8);
                    try {
                        GroupTree groupTree2 = new GroupTree("");
                        int rules = groupTree2.loadNodes(lines);
                        this.logger.info("Loaded {} group rules for remote repository {}", (Object)rules, (Object)remoteRepository.getId());
                        if (this.logger.isDebugEnabled()) {
                            groupTree2.dump("");
                        }
                        groupTree = groupTree2;
                        if (lines == null) break block11;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (lines != null) {
                                try {
                                    lines.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (IOException e) {
                            throw new UncheckedIOException(e);
                        }
                    }
                    lines.close();
                }
                return groupTree;
            }
            this.logger.debug("Group rules file for remote repository {} not available", (Object)remoteRepository);
            return GroupTree.SENTINEL;
        }
        this.logger.debug("Group rules file for remote repository {} disabled", (Object)remoteRepository);
        return GroupTree.SENTINEL;
    }

    private boolean isRecord(RepositorySystemSession session) {
        return ConfigUtils.getBoolean((RepositorySystemSession)session, (boolean)false, (String[])new String[]{CONFIG_PROP_RECORD});
    }

    private void saveRecordedLines() {
        ArrayList<IOException> exceptions = new ArrayList<IOException>();
        for (Map.Entry<RemoteRepository, Path> entry : this.ruleFiles.entrySet()) {
            Set<String> recorded = this.recordedRules.get(entry.getKey());
            if (recorded == null || recorded.isEmpty()) continue;
            try {
                ArrayList<String> result = new ArrayList<String>();
                if (Files.isReadable(entry.getValue())) {
                    result.addAll(Files.readAllLines(entry.getValue()));
                }
                result.add("# Recorded entries");
                result.addAll(recorded);
                this.logger.info("Saving {} groupIds to '{}'", (Object)result.size(), (Object)entry.getValue());
                this.pathProcessor.writeWithBackup(entry.getValue(), result.stream().collect(Collectors.joining(System.lineSeparator())));
            }
            catch (IOException e) {
                exceptions.add(e);
            }
        }
        MultiRuntimeException.mayThrow((String)"session save groupIds failure", exceptions);
    }

    private class GroupIdFilter
    implements RemoteRepositoryFilter {
        private final RepositorySystemSession session;

        private GroupIdFilter(RepositorySystemSession session) {
            this.session = session;
        }

        public RemoteRepositoryFilter.Result acceptArtifact(RemoteRepository remoteRepository, Artifact artifact) {
            return this.acceptGroupId(remoteRepository, artifact.getGroupId());
        }

        public RemoteRepositoryFilter.Result acceptMetadata(RemoteRepository remoteRepository, Metadata metadata) {
            return this.acceptGroupId(remoteRepository, metadata.getGroupId());
        }

        private RemoteRepositoryFilter.Result acceptGroupId(RemoteRepository remoteRepository, String groupId) {
            GroupTree groupTree = GroupIdRemoteRepositoryFilterSource.this.cacheRules(this.session, remoteRepository);
            if (GroupTree.SENTINEL == groupTree) {
                return NOT_PRESENT_RESULT;
            }
            if (groupTree.acceptedGroupId(groupId)) {
                return new RemoteRepositoryFilterSourceSupport.SimpleResult(true, "G:" + groupId + " allowed from " + remoteRepository);
            }
            return new RemoteRepositoryFilterSourceSupport.SimpleResult(false, "G:" + groupId + " NOT allowed from " + remoteRepository);
        }
    }
}

