/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.search;

import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.search.AddressTerm;

public final class RecipientTerm
extends AddressTerm {
    private static final long serialVersionUID = 6548700653122680468L;
    protected Message.RecipientType type;

    public RecipientTerm(Message.RecipientType type, Address address) {
        super(address);
        this.type = type;
    }

    public Message.RecipientType getRecipientType() {
        return this.type;
    }

    public boolean match(Message message) {
        try {
            Address[] from = message.getRecipients(this.type);
            if (from == null) {
                return false;
            }
            for (int i = 0; i < from.length; ++i) {
                Address address = from[i];
                if (!this.match(address)) continue;
                return true;
            }
            return false;
        }
        catch (MessagingException e) {
            return false;
        }
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RecipientTerm)) {
            return false;
        }
        RecipientTerm recipientTerm = (RecipientTerm)other;
        return this.address.equals(recipientTerm.address) && this.type == recipientTerm.type;
    }

    public int hashCode() {
        return this.address.hashCode() + this.type.hashCode();
    }
}

