/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.catalog.jpa.service;

import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.catalog.jpa.dao.ProductRepository;
import org.apache.logging.log4j.catalog.jpa.model.ProductModel;
import org.apache.logging.log4j.catalog.jpa.service.AbstractPagingAndSortingService;
import org.apache.logging.log4j.catalog.jpa.service.ProductService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Repository
@Transactional
public class ProductServiceImpl
extends AbstractPagingAndSortingService
implements ProductService {
    private static final Logger LOGGER = LogManager.getLogger();
    @Autowired
    private ProductRepository productRepository;

    @Override
    public List<ProductModel> getProducts() {
        return this.productRepository.findAll();
    }

    @Override
    public List<ProductModel> getProducts(String catalogId) {
        return this.productRepository.findByCatalogId(catalogId);
    }

    @Override
    public List<ProductModel> getProducts(int startPage, int itemsPerPage, String sortColumn, String direction) {
        Pageable pageable = this.createPageRequest(startPage, itemsPerPage, sortColumn, direction);
        Page page = this.productRepository.findAll(pageable);
        return page.getContent();
    }

    @Override
    public List<ProductModel> getProducts(String catalogId, int startPage, int itemsPerPage, String sortColumn, String direction) {
        Pageable pageable = this.createPageRequest(startPage, itemsPerPage, sortColumn, direction);
        Page page = this.productRepository.findByCatalogId(catalogId, pageable);
        return page.getContent();
    }

    @Override
    public Optional<ProductModel> getProduct(Long productId) {
        return this.productRepository.findOne(productId);
    }

    @Override
    public Optional<ProductModel> getProduct(String catalogId, String name) {
        return this.productRepository.findByCatalogIdAndName(catalogId, name);
    }

    @Override
    public ProductModel saveProduct(ProductModel product) {
        return this.productRepository.save(product);
    }

    @Override
    public void deleteProduct(Long productId) {
        this.productRepository.deleteById(productId);
    }
}

