/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.catalog.jpa.converter;

import java.util.ArrayList;
import java.util.Map;
import org.apache.logging.log4j.catalog.api.Category;
import org.apache.logging.log4j.catalog.jpa.model.CategoryModel;
import org.apache.logging.log4j.catalog.jpa.model.EventModel;
import org.apache.logging.log4j.catalog.jpa.service.EventService;
import org.modelmapper.AbstractConverter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CategoryConverter
extends AbstractConverter<Category, CategoryModel> {
    @Autowired
    private EventService eventService;

    public CategoryModel convert(Category category) {
        Map<String, EventModel> eventMap = this.eventService.getEventMap();
        CategoryModel model = new CategoryModel();
        model.setId(category.getId());
        model.setCatalogId(category.getCatalogId());
        model.setName(category.getName());
        model.setDescription(category.getDescription());
        model.setDisplayName(category.getDisplayName());
        ArrayList<EventModel> events = new ArrayList<EventModel>(category.getEvents().size());
        for (String name : category.getEvents()) {
            EventModel event = eventMap.get(name);
            if (event != null) {
                events.add(event);
                continue;
            }
            throw new IllegalArgumentException("Unknown event " + name + " for category " + category.getName());
        }
        model.setEvents(events);
        return model;
    }
}

