/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.main.util;

import java.io.File;
import java.net.URI;
import org.apache.karaf.info.ServerInfo;

public class ServerInfoImpl
implements ServerInfo {
    private final File base;
    private final File home;
    private final File data;
    private final File instances;
    private final String[] args;

    public ServerInfoImpl(String[] args, File base, File data, File home, File instances) {
        this.args = args;
        this.base = base;
        this.data = data;
        this.home = home;
        this.instances = instances;
    }

    public File getHomeDirectory() {
        return this.home;
    }

    public String resolveHomePath(String filename) {
        return this.resolveWithBase(this.home, filename).getAbsolutePath();
    }

    public File resolveHome(String filename) {
        return this.resolveWithBase(this.home, filename);
    }

    public URI resolveHome(URI uri) {
        return this.home.toURI().resolve(uri);
    }

    public File getBaseDirectory() {
        return this.base;
    }

    public String resolveBasePath(String filename) {
        return this.resolveWithBase(this.base, filename).getAbsolutePath();
    }

    public File resolveBase(String filename) {
        return this.resolveWithBase(this.base, filename);
    }

    public URI resolveBase(URI uri) {
        return this.base.toURI().resolve(uri);
    }

    public File getDataDirectory() {
        return this.data;
    }

    public File getInstancesDirectory() {
        return this.instances;
    }

    public String[] getArgs() {
        return (String[])this.args.clone();
    }

    private File resolveWithBase(File baseDir, String filename) {
        File file = new File(filename);
        if (file.isAbsolute()) {
            return file;
        }
        return new File(baseDir, filename);
    }
}

