/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudwatchlogs.model.CloudWatchLogsResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.FieldIndex;
import software.amazon.awssdk.services.cloudwatchlogs.model.FieldIndexesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeFieldIndexesResponse
extends CloudWatchLogsResponse
implements ToCopyableBuilder<Builder, DescribeFieldIndexesResponse> {
    private static final SdkField<List<FieldIndex>> FIELD_INDEXES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("fieldIndexes").getter(DescribeFieldIndexesResponse.getter(DescribeFieldIndexesResponse::fieldIndexes)).setter(DescribeFieldIndexesResponse.setter(Builder::fieldIndexes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fieldIndexes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FieldIndex::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(DescribeFieldIndexesResponse.getter(DescribeFieldIndexesResponse::nextToken)).setter(DescribeFieldIndexesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELD_INDEXES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeFieldIndexesResponse.memberNameToFieldInitializer();
    private final List<FieldIndex> fieldIndexes;
    private final String nextToken;

    private DescribeFieldIndexesResponse(BuilderImpl builder) {
        super(builder);
        this.fieldIndexes = builder.fieldIndexes;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasFieldIndexes() {
        return this.fieldIndexes != null && !(this.fieldIndexes instanceof SdkAutoConstructList);
    }

    public final List<FieldIndex> fieldIndexes() {
        return this.fieldIndexes;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFieldIndexes() ? this.fieldIndexes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFieldIndexesResponse)) {
            return false;
        }
        DescribeFieldIndexesResponse other = (DescribeFieldIndexesResponse)((Object)obj);
        return this.hasFieldIndexes() == other.hasFieldIndexes() && Objects.equals(this.fieldIndexes(), other.fieldIndexes()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeFieldIndexesResponse").add("FieldIndexes", this.hasFieldIndexes() ? this.fieldIndexes() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "fieldIndexes": {
                return Optional.ofNullable(clazz.cast(this.fieldIndexes()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("fieldIndexes", FIELD_INDEXES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeFieldIndexesResponse, T> g) {
        return obj -> g.apply((DescribeFieldIndexesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudWatchLogsResponse.BuilderImpl
    implements Builder {
        private List<FieldIndex> fieldIndexes = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFieldIndexesResponse model) {
            super(model);
            this.fieldIndexes(model.fieldIndexes);
            this.nextToken(model.nextToken);
        }

        public final List<FieldIndex.Builder> getFieldIndexes() {
            List<FieldIndex.Builder> result = FieldIndexesCopier.copyToBuilder(this.fieldIndexes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFieldIndexes(Collection<FieldIndex.BuilderImpl> fieldIndexes) {
            this.fieldIndexes = FieldIndexesCopier.copyFromBuilder(fieldIndexes);
        }

        @Override
        public final Builder fieldIndexes(Collection<FieldIndex> fieldIndexes) {
            this.fieldIndexes = FieldIndexesCopier.copy(fieldIndexes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fieldIndexes(FieldIndex ... fieldIndexes) {
            this.fieldIndexes(Arrays.asList(fieldIndexes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fieldIndexes(Consumer<FieldIndex.Builder> ... fieldIndexes) {
            this.fieldIndexes(Stream.of(fieldIndexes).map(c -> (FieldIndex)((FieldIndex.Builder)FieldIndex.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeFieldIndexesResponse build() {
            return new DescribeFieldIndexesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CloudWatchLogsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeFieldIndexesResponse> {
        public Builder fieldIndexes(Collection<FieldIndex> var1);

        public Builder fieldIndexes(FieldIndex ... var1);

        public Builder fieldIndexes(Consumer<FieldIndex.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

