/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.FileRange;
import org.apache.hadoop.fs.VectoredReadUtils;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public interface PositionedReadable {
    public int read(long var1, byte[] var3, int var4, int var5) throws IOException;

    public void readFully(long var1, byte[] var3, int var4, int var5) throws IOException;

    public void readFully(long var1, byte[] var3) throws IOException;

    default public int minSeekForVectorReads() {
        return 16384;
    }

    default public int maxReadSizeForVectorReads() {
        return 0x100000;
    }

    default public void readVectored(List<? extends FileRange> ranges, IntFunction<ByteBuffer> allocate) throws IOException {
        VectoredReadUtils.readVectored(this, ranges, allocate);
    }

    default public void readVectored(List<? extends FileRange> ranges, IntFunction<ByteBuffer> allocate, Consumer<ByteBuffer> release) throws IOException {
        Objects.requireNonNull(release);
        this.readVectored(ranges, allocate);
    }
}

