/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.context.impl.wrappers;

import io.smallrye.context.impl.wrappers.ContextualSupplier;
import java.util.function.Supplier;

public final class ContextualSupplierN<R>
implements ContextualSupplier<R> {
    private ThreadLocal<Object>[] tl;
    private Object[] state;
    private final Supplier<R> supplier;

    public ContextualSupplierN(Supplier<R> supplier, int n) {
        this.supplier = supplier;
        this.tl = new ThreadLocal[n];
        this.state = new Object[n];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public R get() {
        Object[] moved = new Object[this.tl.length];
        for (int i = 0; i < this.tl.length; ++i) {
            moved[i] = this.tl[i].get();
            this.tl[i].set(this.state[i]);
        }
        try {
            R r = this.supplier.get();
            return r;
        }
        finally {
            for (int i = 0; i < this.tl.length; ++i) {
                this.tl[i].set(moved[i]);
            }
        }
    }

    @Override
    public void captureThreadLocal(int index, ThreadLocal<Object> threadLocal, Object value) {
        if (index < 0 || index >= this.state.length) {
            throw new IllegalArgumentException("Illegal index " + index);
        }
        this.tl[index] = threadLocal;
        this.state[index] = value;
    }
}

