/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.catalog.io;

import com.google.common.annotations.VisibleForTesting;
import io.smallrye.common.annotation.Identifier;
import jakarta.annotation.Nonnull;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.iceberg.CatalogUtil;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.io.FileIO;
import org.apache.polaris.core.context.CallContext;
import org.apache.polaris.core.context.RealmContext;
import org.apache.polaris.core.entity.PolarisEntity;
import org.apache.polaris.core.persistence.MetaStoreManagerFactory;
import org.apache.polaris.core.persistence.PolarisMetaStoreManager;
import org.apache.polaris.core.persistence.PolarisResolvedPathWrapper;
import org.apache.polaris.core.storage.AccessConfig;
import org.apache.polaris.core.storage.PolarisCredentialVendor;
import org.apache.polaris.core.storage.PolarisStorageActions;
import org.apache.polaris.core.storage.cache.StorageCredentialCache;
import org.apache.polaris.service.catalog.io.ExceptionMappingFileIO;
import org.apache.polaris.service.catalog.io.FileIOFactory;
import org.apache.polaris.service.catalog.io.FileIOUtil;

@ApplicationScoped
@Identifier(value="default")
public class DefaultFileIOFactory
implements FileIOFactory {
    private final StorageCredentialCache storageCredentialCache;
    private final MetaStoreManagerFactory metaStoreManagerFactory;

    @Inject
    public DefaultFileIOFactory(StorageCredentialCache storageCredentialCache, MetaStoreManagerFactory metaStoreManagerFactory) {
        this.storageCredentialCache = storageCredentialCache;
        this.metaStoreManagerFactory = metaStoreManagerFactory;
    }

    public FileIO loadFileIO(@Nonnull CallContext callContext, @Nonnull String ioImplClassName, @Nonnull Map<String, String> properties, @Nonnull TableIdentifier identifier, @Nonnull Set<String> tableLocations, @Nonnull Set<PolarisStorageActions> storageActions, @Nonnull PolarisResolvedPathWrapper resolvedEntityPath) {
        RealmContext realmContext = callContext.getRealmContext();
        PolarisMetaStoreManager credentialVendor = this.metaStoreManagerFactory.getOrCreateMetaStoreManager(realmContext);
        properties = new HashMap<String, String>(properties);
        Optional storageInfoEntity = FileIOUtil.findStorageInfoFromHierarchy((PolarisResolvedPathWrapper)resolvedEntityPath);
        Optional<AccessConfig> accessConfig = storageInfoEntity.map(arg_0 -> this.lambda$loadFileIO$0(callContext, (PolarisCredentialVendor)credentialVendor, identifier, tableLocations, storageActions, arg_0));
        if (accessConfig.isPresent()) {
            properties.putAll(accessConfig.get().credentials());
            properties.putAll(accessConfig.get().extraProperties());
            properties.putAll(accessConfig.get().internalProperties());
        }
        return this.loadFileIOInternal(ioImplClassName, properties);
    }

    @VisibleForTesting
    FileIO loadFileIOInternal(@Nonnull String ioImplClassName, @Nonnull Map<String, String> properties) {
        return new ExceptionMappingFileIO(CatalogUtil.loadFileIO((String)ioImplClassName, properties, null));
    }

    private /* synthetic */ AccessConfig lambda$loadFileIO$0(CallContext callContext, PolarisCredentialVendor credentialVendor, TableIdentifier identifier, Set tableLocations, Set storageActions, PolarisEntity storageInfo) {
        return FileIOUtil.refreshAccessConfig((CallContext)callContext, (StorageCredentialCache)this.storageCredentialCache, (PolarisCredentialVendor)credentialVendor, (TableIdentifier)identifier, (Set)tableLocations, (Set)storageActions, (PolarisEntity)storageInfo, Optional.empty());
    }

    public DefaultFileIOFactory() {
    }
}

