/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds.orca;

import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.Message;
import io.grpc.Context;
import io.grpc.Contexts;
import io.grpc.ExperimentalApi;
import io.grpc.ForwardingServerCall;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.Status;
import io.grpc.protobuf.ProtoUtils;
import io.grpc.services.CallMetricRecorder;
import io.grpc.services.InternalCallMetricRecorder;
import io.grpc.services.InternalMetricRecorder;
import io.grpc.services.MetricRecorder;
import io.grpc.services.MetricReport;
import io.grpc.xds.shaded.com.github.xds.data.orca.v3.OrcaLoadReport;
import javax.annotation.Nullable;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/9127")
public final class OrcaMetricReportingServerInterceptor
implements ServerInterceptor {
    private static final OrcaMetricReportingServerInterceptor INSTANCE = new OrcaMetricReportingServerInterceptor(null);
    @VisibleForTesting
    static final Metadata.Key<OrcaLoadReport> ORCA_ENDPOINT_LOAD_METRICS_KEY = Metadata.Key.of((String)"endpoint-load-metrics-bin", (Metadata.BinaryMarshaller)ProtoUtils.metadataMarshaller((Message)OrcaLoadReport.getDefaultInstance()));
    @Nullable
    private final MetricRecorder metricRecorder;

    @VisibleForTesting
    OrcaMetricReportingServerInterceptor(@Nullable MetricRecorder metricRecorder) {
        this.metricRecorder = metricRecorder;
    }

    public static OrcaMetricReportingServerInterceptor getInstance() {
        return INSTANCE;
    }

    public static OrcaMetricReportingServerInterceptor create(@Nullable MetricRecorder metricRecorder) {
        return new OrcaMetricReportingServerInterceptor(metricRecorder);
    }

    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
        Context ctx = Context.current();
        CallMetricRecorder callMetricRecorder = (CallMetricRecorder)InternalCallMetricRecorder.CONTEXT_KEY.get(ctx);
        if (callMetricRecorder == null) {
            callMetricRecorder = InternalCallMetricRecorder.newCallMetricRecorder();
            ctx = ctx.withValue(InternalCallMetricRecorder.CONTEXT_KEY, (Object)callMetricRecorder);
        }
        final CallMetricRecorder finalCallMetricRecorder = callMetricRecorder;
        ForwardingServerCall.SimpleForwardingServerCall trailerAttachingCall = new ForwardingServerCall.SimpleForwardingServerCall<ReqT, RespT>(call){

            public void close(Status status, Metadata trailers) {
                OrcaLoadReport.Builder reportBuilder = OrcaMetricReportingServerInterceptor.this.metricRecorder != null ? OrcaMetricReportingServerInterceptor.fromInternalReport(InternalMetricRecorder.getMetricReport((MetricRecorder)OrcaMetricReportingServerInterceptor.this.metricRecorder)) : OrcaLoadReport.newBuilder();
                OrcaMetricReportingServerInterceptor.mergeMetrics(reportBuilder, InternalCallMetricRecorder.finalizeAndDump2((CallMetricRecorder)finalCallMetricRecorder));
                OrcaLoadReport report = reportBuilder.build();
                if (!report.equals(OrcaLoadReport.getDefaultInstance())) {
                    trailers.put(ORCA_ENDPOINT_LOAD_METRICS_KEY, (Object)report);
                }
                super.close(status, trailers);
            }
        };
        return Contexts.interceptCall((Context)ctx, (ServerCall)trailerAttachingCall, (Metadata)headers, next);
    }

    private static OrcaLoadReport.Builder fromInternalReport(MetricReport internalReport) {
        return OrcaLoadReport.newBuilder().setCpuUtilization(internalReport.getCpuUtilization()).setApplicationUtilization(internalReport.getApplicationUtilization()).setMemUtilization(internalReport.getMemoryUtilization()).setRpsFractional(internalReport.getQps()).setEps(internalReport.getEps()).putAllUtilization(internalReport.getUtilizationMetrics()).putAllRequestCost(internalReport.getRequestCostMetrics()).putAllNamedMetrics(internalReport.getNamedMetrics());
    }

    private static void mergeMetrics(OrcaLoadReport.Builder metricRecorderReportBuilder, MetricReport callMetricRecorderReport) {
        double eps;
        double rps;
        double mem;
        double applicationUtilization;
        metricRecorderReportBuilder.putAllUtilization(callMetricRecorderReport.getUtilizationMetrics()).putAllRequestCost(callMetricRecorderReport.getRequestCostMetrics()).putAllNamedMetrics(callMetricRecorderReport.getNamedMetrics());
        double cpu = callMetricRecorderReport.getCpuUtilization();
        if (OrcaMetricReportingServerInterceptor.isReportValueSet(cpu)) {
            metricRecorderReportBuilder.setCpuUtilization(cpu);
        }
        if (OrcaMetricReportingServerInterceptor.isReportValueSet(applicationUtilization = callMetricRecorderReport.getApplicationUtilization())) {
            metricRecorderReportBuilder.setApplicationUtilization(applicationUtilization);
        }
        if (OrcaMetricReportingServerInterceptor.isReportValueSet(mem = callMetricRecorderReport.getMemoryUtilization())) {
            metricRecorderReportBuilder.setMemUtilization(mem);
        }
        if (OrcaMetricReportingServerInterceptor.isReportValueSet(rps = callMetricRecorderReport.getQps())) {
            metricRecorderReportBuilder.setRpsFractional(rps);
        }
        if (OrcaMetricReportingServerInterceptor.isReportValueSet(eps = callMetricRecorderReport.getEps())) {
            metricRecorderReportBuilder.setEps(eps);
        }
    }

    private static boolean isReportValueSet(double value) {
        return value != 0.0;
    }
}

