/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.validation.constraints.NotNull;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Generic Table information. - `name` (REQUIRED): name for the generic table - `format` (REQUIRED): format for the generic table, i.e. \"delta\", \"csv\" - `base-location` (OPTIONAL): table base location in URI format. For example: s3://<my-bucket>/path/to/table.   - The table base location is a location that includes all files for the table.   - A table with multiple disjoint locations (i.e. containing files that are outside the configured base location) is not compliant with the current generic table support in Polaris.   - If no location is provided, clients or users are responsible for managing the location.  - `properties` (OPTIONAL): properties for the generic table passed on creation - `doc` (OPTIONAL): comment or description for the generic table ")
public class GenericTable {
    @NotNull
    private final String name;
    @NotNull
    private final String format;
    private final String baseLocation;
    private final String doc;
    private final Map<String, String> properties;

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="name", required=true)
    public String getName() {
        return this.name;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="format", required=true)
    public String getFormat() {
        return this.format;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="base-location")
    public String getBaseLocation() {
        return this.baseLocation;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="doc")
    public String getDoc() {
        return this.doc;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="properties")
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @JsonCreator
    public GenericTable(@JsonProperty(value="name", required=true) String name, @JsonProperty(value="format", required=true) String format, @JsonProperty(value="base-location") String baseLocation, @JsonProperty(value="doc") String doc, @JsonProperty(value="properties") Map<String, String> properties) {
        this.name = name;
        this.format = format;
        this.baseLocation = baseLocation;
        this.doc = doc;
        this.properties = Objects.requireNonNullElse(properties, new HashMap());
    }

    public GenericTable(String name, String format) {
        this.name = name;
        this.format = format;
        this.baseLocation = null;
        this.doc = null;
        this.properties = new HashMap<String, String>();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String name, String format) {
        return new Builder(name, format);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GenericTable genericTable = (GenericTable)o;
        return Objects.equals(this.name, genericTable.name) && Objects.equals(this.format, genericTable.format) && Objects.equals(this.baseLocation, genericTable.baseLocation) && Objects.equals(this.doc, genericTable.doc) && Objects.equals(this.properties, genericTable.properties);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.format, this.baseLocation, this.doc, this.properties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GenericTable {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    format: ").append(this.toIndentedString(this.format)).append("\n");
        sb.append("    baseLocation: ").append(this.toIndentedString(this.baseLocation)).append("\n");
        sb.append("    doc: ").append(this.toIndentedString(this.doc)).append("\n");
        sb.append("    properties: ").append(this.toIndentedString(this.properties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class Builder {
        private String name;
        private String format;
        private String baseLocation;
        private String doc;
        private Map<String, String> properties;

        private Builder() {
        }

        private Builder(String name, String format) {
            this.name = name;
            this.format = format;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setFormat(String format) {
            this.format = format;
            return this;
        }

        public Builder setBaseLocation(String baseLocation) {
            this.baseLocation = baseLocation;
            return this;
        }

        public Builder setDoc(String doc) {
            this.doc = doc;
            return this;
        }

        public Builder setProperties(Map<String, String> properties) {
            this.properties = properties;
            return this;
        }

        public GenericTable build() {
            GenericTable inst = new GenericTable(this.name, this.format, this.baseLocation, this.doc, this.properties);
            return inst;
        }
    }
}

