/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.variants;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.List;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.variants.VariantArray;
import org.apache.iceberg.variants.VariantUtil;
import org.apache.iceberg.variants.VariantValue;

public class ValueArray
implements VariantArray {
    private SerializationState serializationState = null;
    private List<VariantValue> elements = Lists.newArrayList();

    ValueArray() {
    }

    public VariantValue get(int index) {
        return this.elements.get(index);
    }

    public int numElements() {
        return this.elements.size();
    }

    public void add(VariantValue value) {
        this.elements.add(value);
        this.serializationState = null;
    }

    public int sizeInBytes() {
        if (null == this.serializationState) {
            this.serializationState = new SerializationState(this.elements);
        }
        return this.serializationState.size();
    }

    public int writeTo(ByteBuffer buffer, int offset) {
        Preconditions.checkArgument((buffer.order() == ByteOrder.LITTLE_ENDIAN ? 1 : 0) != 0, (Object)"Invalid byte order: big endian");
        if (null == this.serializationState) {
            this.serializationState = new SerializationState(this.elements);
        }
        return this.serializationState.writeTo(buffer, offset);
    }

    public String toString() {
        return VariantArray.asString((VariantArray)this);
    }

    private static class SerializationState {
        private final List<VariantValue> elements;
        private final int numElements;
        private final boolean isLarge;
        private final int dataSize;
        private final int offsetSize;

        private SerializationState(List<VariantValue> elements) {
            this.elements = elements;
            this.numElements = elements.size();
            this.isLarge = this.numElements > 255;
            int totalDataSize = 0;
            for (VariantValue value : elements) {
                totalDataSize += value.sizeInBytes();
            }
            this.dataSize = totalDataSize;
            this.offsetSize = VariantUtil.sizeOf((int)totalDataSize);
        }

        private int size() {
            return 1 + (this.isLarge ? 4 : 1) + (1 + this.numElements) * this.offsetSize + this.dataSize;
        }

        private int writeTo(ByteBuffer buffer, int offset) {
            int offsetListOffset = offset + 1 + (this.isLarge ? 4 : 1);
            int dataOffset = offsetListOffset + (1 + this.numElements) * this.offsetSize;
            byte header = VariantUtil.arrayHeader((boolean)this.isLarge, (int)this.offsetSize);
            VariantUtil.writeByte((ByteBuffer)buffer, (int)header, (int)offset);
            VariantUtil.writeLittleEndianUnsigned((ByteBuffer)buffer, (int)this.numElements, (int)(offset + 1), (int)(this.isLarge ? 4 : 1));
            int nextValueOffset = 0;
            int index = 0;
            for (VariantValue element : this.elements) {
                VariantUtil.writeLittleEndianUnsigned((ByteBuffer)buffer, (int)nextValueOffset, (int)(offsetListOffset + index * this.offsetSize), (int)this.offsetSize);
                int valueSize = element.writeTo(buffer, dataOffset + nextValueOffset);
                nextValueOffset += valueSize;
                ++index;
            }
            VariantUtil.writeLittleEndianUnsigned((ByteBuffer)buffer, (int)nextValueOffset, (int)(offsetListOffset + index * this.offsetSize), (int)this.offsetSize);
            return dataOffset - offset + this.dataSize;
        }
    }
}

