/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.avro;

import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.iceberg.avro.AvroSchemaUtil;
import org.apache.iceberg.avro.LogicalMap;
import org.apache.iceberg.avro.VariantLogicalType;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;

public abstract class AvroSchemaVisitor<T> {
    private static final String METADATA = "metadata";
    private static final String VALUE = "value";
    private final Deque<String> recordLevels = Lists.newLinkedList();
    private final Deque<String> fieldNames = Lists.newLinkedList();

    public static <T> T visit(Schema schema, AvroSchemaVisitor<T> visitor) {
        switch (schema.getType()) {
            case RECORD: {
                String name = schema.getFullName();
                Preconditions.checkState((!visitor.recordLevels.contains(name) ? 1 : 0) != 0, (String)"Cannot process recursive Avro record %s", (Object)name);
                if (schema.getLogicalType() instanceof VariantLogicalType) {
                    Preconditions.checkArgument((boolean)AvroSchemaUtil.isVariantSchema(schema), (String)"Invalid variant record: %s", (Object)schema);
                    return visitor.variant(schema, AvroSchemaVisitor.visit(schema.getField(METADATA).schema(), visitor), AvroSchemaVisitor.visit(schema.getField(VALUE).schema(), visitor));
                }
                visitor.recordLevels.push(name);
                List fields = schema.getFields();
                ArrayList names = Lists.newArrayListWithExpectedSize((int)fields.size());
                ArrayList results = Lists.newArrayListWithExpectedSize((int)fields.size());
                for (Schema.Field field : schema.getFields()) {
                    names.add(field.name());
                    T result = AvroSchemaVisitor.visitWithName(field.name(), field.schema(), visitor);
                    results.add(result);
                }
                visitor.recordLevels.pop();
                return visitor.record(schema, names, results);
            }
            case UNION: {
                List types = schema.getTypes();
                ArrayList options = Lists.newArrayListWithExpectedSize((int)types.size());
                for (Schema type : types) {
                    options.add(AvroSchemaVisitor.visit(type, visitor));
                }
                return visitor.union(schema, options);
            }
            case ARRAY: {
                if (schema.getLogicalType() instanceof LogicalMap) {
                    return visitor.array(schema, AvroSchemaVisitor.visit(schema.getElementType(), visitor));
                }
                return visitor.array(schema, AvroSchemaVisitor.visitWithName("element", schema.getElementType(), visitor));
            }
            case MAP: {
                return visitor.map(schema, AvroSchemaVisitor.visitWithName(VALUE, schema.getValueType(), visitor));
            }
        }
        return visitor.primitive(schema);
    }

    protected Deque<String> fieldNames() {
        return this.fieldNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T visitWithName(String name, Schema schema, AvroSchemaVisitor<T> visitor) {
        try {
            visitor.fieldNames.addLast(name);
            T t = AvroSchemaVisitor.visit(schema, visitor);
            return t;
        }
        finally {
            visitor.fieldNames.removeLast();
        }
    }

    public T record(Schema record, List<String> names, List<T> fields) {
        return null;
    }

    public T union(Schema union, List<T> options) {
        return null;
    }

    public T array(Schema array, T element) {
        return null;
    }

    public T map(Schema map, T value) {
        return null;
    }

    public T variant(Schema variant, T metadataResult, T valueResult) {
        throw new UnsupportedOperationException("Unsupported type: variant");
    }

    public T primitive(Schema primitive) {
        return null;
    }
}

