/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.view;

import org.apache.iceberg.UpdateLocation;
import org.apache.iceberg.exceptions.CommitFailedException;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.util.PropertyUtil;
import org.apache.iceberg.util.Tasks;
import org.apache.iceberg.view.ViewMetadata;
import org.apache.iceberg.view.ViewOperations;

class SetViewLocation
implements UpdateLocation {
    private final ViewOperations ops;
    private String newLocation = null;

    SetViewLocation(ViewOperations ops) {
        this.ops = ops;
    }

    public String apply() {
        Preconditions.checkState((null != this.newLocation ? 1 : 0) != 0, (Object)"Invalid view location: null");
        return this.newLocation;
    }

    public void commit() {
        ViewMetadata base = this.ops.refresh();
        Tasks.foreach(this.ops).retry(PropertyUtil.propertyAsInt(base.properties(), "commit.retry.num-retries", 4)).exponentialBackoff(PropertyUtil.propertyAsInt(base.properties(), "commit.retry.min-wait-ms", 100), PropertyUtil.propertyAsInt(base.properties(), "commit.retry.max-wait-ms", 60000), PropertyUtil.propertyAsInt(base.properties(), "commit.retry.total-timeout-ms", 1800000), 2.0).onlyRetryOn((Class<Exception>)CommitFailedException.class).run(taskOps -> taskOps.commit(base, ViewMetadata.buildFrom(base).setLocation(this.apply()).build()));
    }

    public UpdateLocation setLocation(String location) {
        this.newLocation = location;
        return this;
    }
}

