/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.metrics;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import org.apache.iceberg.metrics.CounterResultParser;
import org.apache.iceberg.metrics.ImmutableScanMetricsResult;
import org.apache.iceberg.metrics.ScanMetricsResult;
import org.apache.iceberg.metrics.TimerResultParser;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.util.JsonUtil;

class ScanMetricsResultParser {
    private ScanMetricsResultParser() {
    }

    static String toJson(ScanMetricsResult metrics) {
        return ScanMetricsResultParser.toJson(metrics, false);
    }

    static String toJson(ScanMetricsResult metrics, boolean pretty) {
        return JsonUtil.generate(gen -> ScanMetricsResultParser.toJson(metrics, gen), pretty);
    }

    static void toJson(ScanMetricsResult metrics, JsonGenerator gen) throws IOException {
        Preconditions.checkArgument((null != metrics ? 1 : 0) != 0, (Object)"Invalid scan metrics: null");
        gen.writeStartObject();
        if (null != metrics.totalPlanningDuration()) {
            gen.writeFieldName("total-planning-duration");
            TimerResultParser.toJson(metrics.totalPlanningDuration(), gen);
        }
        if (null != metrics.resultDataFiles()) {
            gen.writeFieldName("result-data-files");
            CounterResultParser.toJson(metrics.resultDataFiles(), gen);
        }
        if (null != metrics.resultDeleteFiles()) {
            gen.writeFieldName("result-delete-files");
            CounterResultParser.toJson(metrics.resultDeleteFiles(), gen);
        }
        if (null != metrics.totalDataManifests()) {
            gen.writeFieldName("total-data-manifests");
            CounterResultParser.toJson(metrics.totalDataManifests(), gen);
        }
        if (null != metrics.totalDeleteManifests()) {
            gen.writeFieldName("total-delete-manifests");
            CounterResultParser.toJson(metrics.totalDeleteManifests(), gen);
        }
        if (null != metrics.scannedDataManifests()) {
            gen.writeFieldName("scanned-data-manifests");
            CounterResultParser.toJson(metrics.scannedDataManifests(), gen);
        }
        if (null != metrics.skippedDataManifests()) {
            gen.writeFieldName("skipped-data-manifests");
            CounterResultParser.toJson(metrics.skippedDataManifests(), gen);
        }
        if (null != metrics.totalFileSizeInBytes()) {
            gen.writeFieldName("total-file-size-in-bytes");
            CounterResultParser.toJson(metrics.totalFileSizeInBytes(), gen);
        }
        if (null != metrics.totalDeleteFileSizeInBytes()) {
            gen.writeFieldName("total-delete-file-size-in-bytes");
            CounterResultParser.toJson(metrics.totalDeleteFileSizeInBytes(), gen);
        }
        if (null != metrics.skippedDataFiles()) {
            gen.writeFieldName("skipped-data-files");
            CounterResultParser.toJson(metrics.skippedDataFiles(), gen);
        }
        if (null != metrics.skippedDeleteFiles()) {
            gen.writeFieldName("skipped-delete-files");
            CounterResultParser.toJson(metrics.skippedDeleteFiles(), gen);
        }
        if (null != metrics.scannedDeleteManifests()) {
            gen.writeFieldName("scanned-delete-manifests");
            CounterResultParser.toJson(metrics.scannedDeleteManifests(), gen);
        }
        if (null != metrics.skippedDeleteManifests()) {
            gen.writeFieldName("skipped-delete-manifests");
            CounterResultParser.toJson(metrics.skippedDeleteManifests(), gen);
        }
        if (null != metrics.indexedDeleteFiles()) {
            gen.writeFieldName("indexed-delete-files");
            CounterResultParser.toJson(metrics.indexedDeleteFiles(), gen);
        }
        if (null != metrics.equalityDeleteFiles()) {
            gen.writeFieldName("equality-delete-files");
            CounterResultParser.toJson(metrics.equalityDeleteFiles(), gen);
        }
        if (null != metrics.positionalDeleteFiles()) {
            gen.writeFieldName("positional-delete-files");
            CounterResultParser.toJson(metrics.positionalDeleteFiles(), gen);
        }
        if (null != metrics.dvs()) {
            gen.writeFieldName("dvs");
            CounterResultParser.toJson(metrics.dvs(), gen);
        }
        gen.writeEndObject();
    }

    static ScanMetricsResult fromJson(String json) {
        return JsonUtil.parse(json, ScanMetricsResultParser::fromJson);
    }

    static ScanMetricsResult fromJson(JsonNode json) {
        Preconditions.checkArgument((null != json ? 1 : 0) != 0, (Object)"Cannot parse scan metrics from null object");
        Preconditions.checkArgument((boolean)json.isObject(), (String)"Cannot parse scan metrics from non-object: %s", (Object)json);
        return ImmutableScanMetricsResult.builder().totalPlanningDuration(TimerResultParser.fromJson("total-planning-duration", json)).resultDataFiles(CounterResultParser.fromJson("result-data-files", json)).resultDeleteFiles(CounterResultParser.fromJson("result-delete-files", json)).totalDataManifests(CounterResultParser.fromJson("total-data-manifests", json)).totalDeleteManifests(CounterResultParser.fromJson("total-delete-manifests", json)).scannedDataManifests(CounterResultParser.fromJson("scanned-data-manifests", json)).skippedDataManifests(CounterResultParser.fromJson("skipped-data-manifests", json)).totalFileSizeInBytes(CounterResultParser.fromJson("total-file-size-in-bytes", json)).totalDeleteFileSizeInBytes(CounterResultParser.fromJson("total-delete-file-size-in-bytes", json)).skippedDataFiles(CounterResultParser.fromJson("skipped-data-files", json)).skippedDeleteFiles(CounterResultParser.fromJson("skipped-delete-files", json)).scannedDeleteManifests(CounterResultParser.fromJson("scanned-delete-manifests", json)).skippedDeleteManifests(CounterResultParser.fromJson("skipped-delete-manifests", json)).indexedDeleteFiles(CounterResultParser.fromJson("indexed-delete-files", json)).equalityDeleteFiles(CounterResultParser.fromJson("equality-delete-files", json)).positionalDeleteFiles(CounterResultParser.fromJson("positional-delete-files", json)).dvs(CounterResultParser.fromJson("dvs", json)).build();
    }
}

