/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.context;

import io.smallrye.common.vertx.ContextLocals;
import io.smallrye.mutiny.Uni;
import jakarta.inject.Inject;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import org.apache.iceberg.rest.responses.ErrorResponse;
import org.apache.polaris.service.context.RealmContextResolver;
import org.jboss.resteasy.reactive.server.ServerRequestFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RealmContextFilter {
    public static final String REALM_CONTEXT_KEY = "realmContext";
    private static final Logger LOGGER = LoggerFactory.getLogger(RealmContextFilter.class);
    @Inject
    RealmContextResolver realmContextResolver;

    @ServerRequestFilter(preMatching=true, priority=900)
    public Uni<Response> resolveRealmContext(ContainerRequestContext rc) {
        return Uni.createFrom().completionStage(() -> this.realmContextResolver.resolveRealmContext(rc.getUriInfo().getRequestUri().toString(), rc.getMethod(), rc.getUriInfo().getPath(), arg_0 -> ((MultivaluedMap)rc.getHeaders()).getFirst(arg_0))).onItem().invoke(realmContext -> rc.setProperty(REALM_CONTEXT_KEY, realmContext)).invoke(realmContext -> ContextLocals.put((String)REALM_CONTEXT_KEY, (Object)realmContext)).onItemOrFailure().transform((realmContext, error) -> error == null ? null : RealmContextFilter.errorResponse(error));
    }

    private static Response errorResponse(Throwable error) {
        LOGGER.error("Error resolving realm context", error);
        return Response.status((Response.Status)Response.Status.NOT_FOUND).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)ErrorResponse.builder().responseCode(Integer.valueOf(Response.Status.NOT_FOUND.getStatusCode())).withMessage("Missing or invalid realm").withType("MissingOrInvalidRealm").build()).build();
    }
}

