/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.util.Map;
import java.util.Optional;
import org.apache.polaris.core.config.PolarisConfigurationStore;
import org.apache.polaris.core.context.RealmContext;
import org.apache.polaris.service.config.FeaturesConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class DefaultConfigurationStore
implements PolarisConfigurationStore {
    Logger LOGGER = LoggerFactory.getLogger(DefaultConfigurationStore.class);
    private final Map<String, Object> defaults;
    private final Map<String, Map<String, Object>> realmOverrides;

    @Inject
    public DefaultConfigurationStore(ObjectMapper objectMapper, FeaturesConfiguration configurations) {
        this.defaults = Map.copyOf(configurations.parseDefaults(objectMapper));
        this.realmOverrides = Map.copyOf(configurations.parseRealmOverrides(objectMapper));
    }

    @Nullable
    public <T> T getConfiguration(@Nonnull RealmContext realmContext, String configName) {
        String realm = realmContext.getRealmIdentifier();
        this.LOGGER.debug("Get configuration value for {} with realm {}", (Object)configName, (Object)realm);
        Object confgValue = Optional.ofNullable(this.realmOverrides.getOrDefault(realm, Map.of()).get(configName)).orElseGet(() -> this.getDefaultConfiguration(configName));
        return (T)confgValue;
    }

    @Nullable
    private <T> T getDefaultConfiguration(String configName) {
        Object confgValue = this.defaults.get(configName);
        return (T)confgValue;
    }
}

