/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.jwt.auth.cdi;

import io.smallrye.jwt.JsonUtils;
import io.smallrye.jwt.auth.cdi.CDILogging;
import io.smallrye.jwt.auth.cdi.RawClaimTypeProducer;
import jakarta.enterprise.inject.Produces;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.inject.Inject;
import java.util.Optional;
import java.util.Set;
import org.eclipse.microprofile.jwt.Claim;
import org.eclipse.microprofile.jwt.JsonWebToken;

public class OptionalClaimTypeProducer {
    @Inject
    JsonWebToken currentToken;

    @Produces
    @Claim(value="")
    public Optional<String> getOptionalString(InjectionPoint ip) {
        CDILogging.log.getOptionalString(ip);
        if (this.currentToken == null) {
            return Optional.empty();
        }
        return Optional.ofNullable((String)JsonUtils.convert(String.class, this.currentToken.getClaim(RawClaimTypeProducer.getName(ip))));
    }

    @Produces
    @Claim(value="")
    public Optional<Set<String>> getOptionalStringSet(InjectionPoint ip) {
        CDILogging.log.getOptionalStringSet(ip);
        if (this.currentToken == null) {
            return Optional.empty();
        }
        return Optional.ofNullable((Set)JsonUtils.convert(Set.class, this.currentToken.getClaim(RawClaimTypeProducer.getName(ip))));
    }

    @Produces
    @Claim(value="")
    public Optional<Long> getOptionalLong(InjectionPoint ip) {
        CDILogging.log.getOptionalLong(ip);
        if (this.currentToken == null) {
            return Optional.empty();
        }
        return Optional.ofNullable((Long)JsonUtils.convert(Long.class, this.currentToken.getClaim(RawClaimTypeProducer.getName(ip))));
    }

    @Produces
    @Claim(value="")
    public Optional<Boolean> getOptionalBoolean(InjectionPoint ip) {
        CDILogging.log.getOptionalBoolean(ip);
        if (this.currentToken == null) {
            return Optional.empty();
        }
        return Optional.ofNullable((Boolean)JsonUtils.convert(Boolean.class, this.currentToken.getClaim(RawClaimTypeProducer.getName(ip))));
    }
}

