/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOutboundHandler;
import java.util.Objects;
import reactor.core.Disposable;
import reactor.core.publisher.Mono;
import reactor.netty.DisposableChannel;
import reactor.netty.NettyInbound;
import reactor.netty.NettyOutbound;
import reactor.netty.ReactorNetty;
import reactor.util.annotation.Nullable;

@FunctionalInterface
public interface Connection
extends DisposableChannel {
    public static Connection from(Channel channel) {
        Objects.requireNonNull(channel, "channel");
        if (channel.hasAttr(ReactorNetty.CONNECTION)) {
            return (Connection)channel.attr(ReactorNetty.CONNECTION).get();
        }
        return new ReactorNetty.SimpleConnection(channel).bind();
    }

    @Nullable
    default public <T extends Connection> T as(Class<T> clazz) {
        Objects.requireNonNull(clazz, "clazz");
        if (clazz.isAssignableFrom(this.getClass())) {
            Connection thiz = this;
            return (T)thiz;
        }
        return null;
    }

    @Deprecated
    default public Connection addHandler(ChannelHandler handler) {
        return this.addHandler(handler.getClass().getSimpleName(), handler);
    }

    @Deprecated
    default public Connection addHandler(String name, ChannelHandler handler) {
        if (handler instanceof ChannelOutboundHandler) {
            this.addHandlerFirst(name, handler);
        } else {
            this.addHandlerLast(name, handler);
        }
        return this;
    }

    default public Connection addHandlerLast(ChannelHandler handler) {
        return this.addHandlerLast(handler.getClass().getSimpleName(), handler);
    }

    default public Connection addHandlerLast(String name, ChannelHandler handler) {
        ReactorNetty.addHandlerBeforeReactorEndHandlers(this, name, handler);
        return this;
    }

    default public Connection addHandlerFirst(ChannelHandler handler) {
        return this.addHandlerFirst(handler.getClass().getSimpleName(), handler);
    }

    default public Connection addHandlerFirst(String name, ChannelHandler handler) {
        ReactorNetty.addHandlerAfterReactorCodecs(this, name, handler);
        return this;
    }

    default public Connection bind() {
        this.channel().attr(ReactorNetty.CONNECTION).set((Object)this);
        return this;
    }

    default public NettyInbound inbound() {
        return ReactorNetty.unavailableInbound(this);
    }

    default public boolean isPersistent() {
        return !this.channel().hasAttr(ReactorNetty.PERSISTENT_CHANNEL) || (Boolean)this.channel().attr(ReactorNetty.PERSISTENT_CHANNEL).get() != false;
    }

    default public Connection markPersistent(boolean persist) {
        if (persist && !this.channel().hasAttr(ReactorNetty.PERSISTENT_CHANNEL)) {
            return this;
        }
        this.channel().attr(ReactorNetty.PERSISTENT_CHANNEL).set((Object)persist);
        return this;
    }

    @Override
    default public Connection onDispose(Disposable onDispose) {
        DisposableChannel.super.onDispose(onDispose);
        return this;
    }

    default public Connection onReadIdle(long idleTimeout, Runnable onReadIdle) {
        return this.removeHandler("reactor.left.onChannelReadIdle").addHandlerFirst("reactor.left.onChannelReadIdle", (ChannelHandler)new ReactorNetty.InboundIdleStateHandler(idleTimeout, onReadIdle));
    }

    default public Mono<Void> onTerminate() {
        return this.onDispose();
    }

    default public Connection onWriteIdle(long idleTimeout, Runnable onWriteIdle) {
        return this.removeHandler("reactor.left.onChannelWriteIdle").addHandlerFirst("reactor.left.onChannelWriteIdle", (ChannelHandler)new ReactorNetty.OutboundIdleStateHandler(idleTimeout, onWriteIdle));
    }

    default public NettyOutbound outbound() {
        return ReactorNetty.unavailableOutbound(this);
    }

    default public boolean rebind(@Nullable Connection connection) {
        return this.channel().attr(ReactorNetty.CONNECTION).compareAndSet((Object)this, (Object)connection);
    }

    default public Connection removeHandler(String name) {
        ReactorNetty.removeHandler(this.channel(), name);
        return this;
    }

    default public Connection replaceHandler(String name, ChannelHandler handler) {
        ReactorNetty.replaceHandler(this.channel(), name, handler);
        return this;
    }
}

