/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.util.actions;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;

public final class GetDeclaredMethodHandle {
    private static final Log LOG = LoggerFactory.make(MethodHandles.lookup());

    private GetDeclaredMethodHandle() {
    }

    public static MethodHandle action(MethodHandles.Lookup lookup, Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        return GetDeclaredMethodHandle.action(lookup, clazz, methodName, false, parameterTypes);
    }

    public static MethodHandle andMakeAccessible(MethodHandles.Lookup lookup, Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        return GetDeclaredMethodHandle.action(lookup, clazz, methodName, true, parameterTypes);
    }

    private static MethodHandle action(MethodHandles.Lookup lookup, Class<?> clazz, String methodName, boolean makeAccessible, Class<?> ... parameterTypes) {
        try {
            Method method = clazz.getDeclaredMethod(methodName, parameterTypes);
            if (makeAccessible) {
                method.setAccessible(true);
            }
            return lookup.unreflect(method);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            throw LOG.getUnableToAccessMethodException(lookup, clazz, methodName, parameterTypes, e);
        }
    }
}

