/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.policybuilder.iam;

import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.policybuilder.iam.IamAction;
import software.amazon.awssdk.policybuilder.iam.IamCondition;
import software.amazon.awssdk.policybuilder.iam.IamConditionKey;
import software.amazon.awssdk.policybuilder.iam.IamConditionOperator;
import software.amazon.awssdk.policybuilder.iam.IamEffect;
import software.amazon.awssdk.policybuilder.iam.IamPrincipal;
import software.amazon.awssdk.policybuilder.iam.IamPrincipalType;
import software.amazon.awssdk.policybuilder.iam.IamResource;
import software.amazon.awssdk.policybuilder.iam.internal.DefaultIamStatement;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@SdkPublicApi
@ThreadSafe
public interface IamStatement
extends ToCopyableBuilder<Builder, IamStatement> {
    public static Builder builder() {
        return DefaultIamStatement.builder();
    }

    public String sid();

    public IamEffect effect();

    public List<IamPrincipal> principals();

    public List<IamPrincipal> notPrincipals();

    public List<IamAction> actions();

    public List<IamAction> notActions();

    public List<IamResource> resources();

    public List<IamResource> notResources();

    public List<IamCondition> conditions();

    public static interface Builder
    extends CopyableBuilder<Builder, IamStatement> {
        public Builder sid(String var1);

        public Builder effect(IamEffect var1);

        public Builder effect(String var1);

        public Builder principals(Collection<IamPrincipal> var1);

        public Builder addPrincipal(IamPrincipal var1);

        public Builder addPrincipal(Consumer<IamPrincipal.Builder> var1);

        public Builder addPrincipal(IamPrincipalType var1, String var2);

        public Builder addPrincipal(String var1, String var2);

        public Builder addPrincipals(IamPrincipalType var1, Collection<String> var2);

        public Builder addPrincipals(String var1, Collection<String> var2);

        public Builder notPrincipals(Collection<IamPrincipal> var1);

        public Builder addNotPrincipal(IamPrincipal var1);

        public Builder addNotPrincipal(Consumer<IamPrincipal.Builder> var1);

        public Builder addNotPrincipal(IamPrincipalType var1, String var2);

        public Builder addNotPrincipal(String var1, String var2);

        public Builder addNotPrincipals(IamPrincipalType var1, Collection<String> var2);

        public Builder addNotPrincipals(String var1, Collection<String> var2);

        public Builder actions(Collection<IamAction> var1);

        public Builder actionIds(Collection<String> var1);

        public Builder addAction(IamAction var1);

        public Builder addAction(String var1);

        public Builder notActions(Collection<IamAction> var1);

        public Builder notActionIds(Collection<String> var1);

        public Builder addNotAction(IamAction var1);

        public Builder addNotAction(String var1);

        public Builder resources(Collection<IamResource> var1);

        public Builder resourceIds(Collection<String> var1);

        public Builder addResource(IamResource var1);

        public Builder addResource(String var1);

        public Builder notResources(Collection<IamResource> var1);

        public Builder notResourceIds(Collection<String> var1);

        public Builder addNotResource(IamResource var1);

        public Builder addNotResource(String var1);

        public Builder conditions(Collection<IamCondition> var1);

        public Builder addCondition(IamCondition var1);

        public Builder addCondition(Consumer<IamCondition.Builder> var1);

        public Builder addCondition(IamConditionOperator var1, IamConditionKey var2, String var3);

        public Builder addCondition(IamConditionOperator var1, String var2, String var3);

        public Builder addCondition(String var1, String var2, String var3);

        public Builder addConditions(IamConditionOperator var1, IamConditionKey var2, Collection<String> var3);

        public Builder addConditions(IamConditionOperator var1, String var2, Collection<String> var3);

        public Builder addConditions(String var1, String var2, Collection<String> var3);
    }
}

