/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ApplicablePolicy {
    @NotNull
    private final String policyType;
    @NotNull
    private final Boolean inheritable;
    @NotNull
    @Pattern(regexp="^[A-Za-z0-9\\-_]+$")
    private final @NotNull @Pattern(regexp="^[A-Za-z0-9\\-_]+$") String name;
    private final String description;
    private final String content;
    @NotNull
    private final Integer version;
    @NotNull
    private final Boolean inherited;
    @NotNull
    private final List<String> namespace;

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="policy-type", required=true)
    public String getPolicyType() {
        return this.policyType;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="inheritable", required=true)
    public Boolean getInheritable() {
        return this.inheritable;
    }

    @ApiModelProperty(example="compaction", required=true, value="A policy name. A valid policy name should only consist of uppercase and lowercase letters (A-Z, a-z), digits (0-9), hyphens (-), underscores (_).")
    @JsonProperty(value="name", required=true)
    public String getName() {
        return this.name;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="content")
    public String getContent() {
        return this.content;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="version", required=true)
    public Integer getVersion() {
        return this.version;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="inherited", required=true)
    public Boolean getInherited() {
        return this.inherited;
    }

    @ApiModelProperty(example="[\"accounting\",\"tax\"]", required=true, value="Reference to one or more levels of a namespace")
    @JsonProperty(value="namespace", required=true)
    public List<String> getNamespace() {
        return this.namespace;
    }

    @JsonCreator
    public ApplicablePolicy(@JsonProperty(value="policy-type", required=true) String policyType, @JsonProperty(value="inheritable", required=true) Boolean inheritable, @JsonProperty(value="name", required=true) String name, @JsonProperty(value="description") String description, @JsonProperty(value="content") String content, @JsonProperty(value="version", required=true) Integer version, @JsonProperty(value="inherited", required=true) Boolean inherited, @JsonProperty(value="namespace", required=true) List<String> namespace) {
        this.policyType = policyType;
        this.inheritable = inheritable;
        this.name = name;
        this.description = description;
        this.content = content;
        this.version = version;
        this.inherited = Objects.requireNonNullElse(inherited, false);
        this.namespace = Objects.requireNonNullElse(namespace, new ArrayList());
    }

    public ApplicablePolicy(String policyType, Boolean inheritable, String name, Integer version, Boolean inherited, List<String> namespace) {
        this.policyType = policyType;
        this.inheritable = inheritable;
        this.name = name;
        this.description = null;
        this.content = null;
        this.version = version;
        this.inherited = Objects.requireNonNullElse(inherited, false);
        this.namespace = Objects.requireNonNullElse(namespace, new ArrayList());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String policyType, Boolean inheritable, String name, Integer version, Boolean inherited, List<String> namespace) {
        return new Builder(policyType, inheritable, name, version, inherited, namespace);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApplicablePolicy applicablePolicy = (ApplicablePolicy)o;
        return Objects.equals(this.policyType, applicablePolicy.policyType) && Objects.equals(this.inheritable, applicablePolicy.inheritable) && Objects.equals(this.name, applicablePolicy.name) && Objects.equals(this.description, applicablePolicy.description) && Objects.equals(this.content, applicablePolicy.content) && Objects.equals(this.version, applicablePolicy.version) && Objects.equals(this.inherited, applicablePolicy.inherited) && Objects.equals(this.namespace, applicablePolicy.namespace);
    }

    public int hashCode() {
        return Objects.hash(this.policyType, this.inheritable, this.name, this.description, this.content, this.version, this.inherited, this.namespace);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApplicablePolicy {\n");
        sb.append("    policyType: ").append(this.toIndentedString(this.policyType)).append("\n");
        sb.append("    inheritable: ").append(this.toIndentedString(this.inheritable)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    content: ").append(this.toIndentedString(this.content)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    inherited: ").append(this.toIndentedString(this.inherited)).append("\n");
        sb.append("    namespace: ").append(this.toIndentedString(this.namespace)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class Builder {
        private String policyType;
        private Boolean inheritable;
        private String name;
        private String description;
        private String content;
        private Integer version;
        private Boolean inherited;
        private List<String> namespace;

        private Builder() {
        }

        private Builder(String policyType, Boolean inheritable, String name, Integer version, Boolean inherited, List<String> namespace) {
            this.policyType = policyType;
            this.inheritable = inheritable;
            this.name = name;
            this.version = version;
            this.inherited = Objects.requireNonNullElse(inherited, false);
            this.namespace = Objects.requireNonNullElse(namespace, new ArrayList());
        }

        public Builder setPolicyType(String policyType) {
            this.policyType = policyType;
            return this;
        }

        public Builder setInheritable(Boolean inheritable) {
            this.inheritable = inheritable;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder setContent(String content) {
            this.content = content;
            return this;
        }

        public Builder setVersion(Integer version) {
            this.version = version;
            return this;
        }

        public Builder setInherited(Boolean inherited) {
            this.inherited = inherited;
            return this;
        }

        public Builder setNamespace(List<String> namespace) {
            this.namespace = namespace;
            return this;
        }

        public ApplicablePolicy build() {
            ApplicablePolicy inst = new ApplicablePolicy(this.policyType, this.inheritable, this.name, this.description, this.content, this.version, this.inherited, this.namespace);
            return inst;
        }
    }
}

