/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.persistence.relational.jdbc;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Produces;
import java.sql.SQLException;
import org.apache.polaris.core.config.ProductionReadinessCheck;
import org.apache.polaris.core.persistence.MetaStoreManagerFactory;
import org.apache.polaris.persistence.relational.jdbc.DatabaseType;
import org.apache.polaris.persistence.relational.jdbc.JdbcMetaStoreManagerFactory;

@ApplicationScoped
public class RelationalJdbcProductionReadinessChecks {
    @Produces
    public ProductionReadinessCheck checkRelationalJdbc(MetaStoreManagerFactory metaStoreManagerFactory) {
        if (!(metaStoreManagerFactory instanceof JdbcMetaStoreManagerFactory)) {
            return ProductionReadinessCheck.OK;
        }
        JdbcMetaStoreManagerFactory jdbcMetaStoreManagerFactory = (JdbcMetaStoreManagerFactory)metaStoreManagerFactory;
        try {
            if (jdbcMetaStoreManagerFactory.getDatabaseType().equals((Object)DatabaseType.H2)) {
                return ProductionReadinessCheck.of((ProductionReadinessCheck.Error[])new ProductionReadinessCheck.Error[]{ProductionReadinessCheck.Error.of((String)"The current persistence (jdbc:h2) is intended for tests only.", (String)"quarkus.datasource.jdbc.url")});
            }
        }
        catch (SQLException e) {
            return ProductionReadinessCheck.of((ProductionReadinessCheck.Error[])new ProductionReadinessCheck.Error[]{ProductionReadinessCheck.Error.of((String)"Misconfigured JDBC datasource", (String)"quarkus.datasource.jdbc.url")});
        }
        return ProductionReadinessCheck.OK;
    }
}

