/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.deletes;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.deletes.BitmapPositionDeleteIndex;
import org.apache.iceberg.deletes.DeleteGranularity;
import org.apache.iceberg.deletes.PositionDelete;
import org.apache.iceberg.deletes.PositionDeleteIndex;
import org.apache.iceberg.io.DeleteWriteResult;
import org.apache.iceberg.io.FileWriter;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.types.Comparators;
import org.apache.iceberg.util.CharSequenceMap;
import org.apache.iceberg.util.CharSequenceSet;
import org.apache.iceberg.util.ContentFileUtil;

public class SortingPositionOnlyDeleteWriter<T>
implements FileWriter<PositionDelete<T>, DeleteWriteResult> {
    private final Supplier<FileWriter<PositionDelete<T>, DeleteWriteResult>> writers;
    private final DeleteGranularity granularity;
    private final CharSequenceMap<PositionDeleteIndex> positionsByPath;
    private final Function<CharSequence, PositionDeleteIndex> loadPreviousDeletes;
    private DeleteWriteResult result = null;

    public SortingPositionOnlyDeleteWriter(FileWriter<PositionDelete<T>, DeleteWriteResult> writer) {
        this(() -> writer, DeleteGranularity.PARTITION);
    }

    public SortingPositionOnlyDeleteWriter(Supplier<FileWriter<PositionDelete<T>, DeleteWriteResult>> writers, DeleteGranularity granularity) {
        this(writers, granularity, path -> null);
    }

    public SortingPositionOnlyDeleteWriter(Supplier<FileWriter<PositionDelete<T>, DeleteWriteResult>> writers, DeleteGranularity granularity, Function<CharSequence, PositionDeleteIndex> loadPreviousDeletes) {
        this.writers = writers;
        this.granularity = granularity;
        this.positionsByPath = CharSequenceMap.create();
        this.loadPreviousDeletes = loadPreviousDeletes;
    }

    @Override
    public void write(PositionDelete<T> positionDelete) {
        CharSequence path = positionDelete.path();
        long position = positionDelete.pos();
        PositionDeleteIndex positions = (PositionDeleteIndex)this.positionsByPath.computeIfAbsent((Object)path, key -> new BitmapPositionDeleteIndex());
        positions.delete(position);
    }

    @Override
    public long length() {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not implement length");
    }

    @Override
    public DeleteWriteResult result() {
        return this.result;
    }

    @Override
    public void close() throws IOException {
        if (this.result == null) {
            switch (this.granularity) {
                case FILE: {
                    this.result = this.writeFileDeletes();
                    return;
                }
                case PARTITION: {
                    this.result = this.writePartitionDeletes();
                    return;
                }
            }
            throw new UnsupportedOperationException("Unsupported delete granularity: " + this.granularity);
        }
    }

    private DeleteWriteResult writePartitionDeletes() throws IOException {
        return this.writeDeletes(this.positionsByPath.keySet());
    }

    private DeleteWriteResult writeFileDeletes() throws IOException {
        ArrayList deleteFiles = Lists.newArrayList();
        CharSequenceSet referencedDataFiles = CharSequenceSet.empty();
        ArrayList rewrittenDeleteFiles = Lists.newArrayList();
        for (CharSequence path : this.positionsByPath.keySet()) {
            DeleteWriteResult writeResult = this.writeDeletes((Collection<CharSequence>)ImmutableList.of((Object)path));
            deleteFiles.addAll(writeResult.deleteFiles());
            referencedDataFiles.addAll((Collection)writeResult.referencedDataFiles());
            rewrittenDeleteFiles.addAll(writeResult.rewrittenDeleteFiles());
        }
        return new DeleteWriteResult(deleteFiles, referencedDataFiles, rewrittenDeleteFiles);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DeleteWriteResult writeDeletes(Collection<CharSequence> paths) throws IOException {
        if (paths.isEmpty()) {
            return new DeleteWriteResult(Lists.newArrayList(), CharSequenceSet.empty());
        }
        ArrayList rewrittenDeleteFiles = Lists.newArrayList();
        try (FileWriter writer = this.writers.get();){
            PositionDelete positionDelete = PositionDelete.create();
            for (CharSequence path : this.sort(paths)) {
                PositionDeleteIndex positions = (PositionDeleteIndex)this.positionsByPath.get((Object)path);
                PositionDeleteIndex previousPositions = this.loadPreviousDeletes.apply(path);
                if (previousPositions != null && previousPositions.isNotEmpty()) {
                    this.validatePreviousDeletes(previousPositions);
                    positions.merge(previousPositions);
                    rewrittenDeleteFiles.addAll(previousPositions.deleteFiles());
                }
                positions.forEach(position -> writer.write(positionDelete.set(path, position)));
            }
        }
        DeleteWriteResult writerResult = writer.result();
        List<DeleteFile> deleteFiles = writerResult.deleteFiles();
        CharSequenceSet referencedDataFiles = writerResult.referencedDataFiles();
        return new DeleteWriteResult(deleteFiles, referencedDataFiles, rewrittenDeleteFiles);
    }

    private void validatePreviousDeletes(PositionDeleteIndex index) {
        Preconditions.checkArgument((boolean)index.deleteFiles().stream().allMatch(ContentFileUtil::isFileScoped), (Object)"Previous deletes must be file-scoped");
    }

    private Collection<CharSequence> sort(Collection<CharSequence> paths) {
        if (paths.size() <= 1) {
            return paths;
        }
        ArrayList sortedPaths = Lists.newArrayList(paths);
        sortedPaths.sort(Comparators.charSequences());
        return sortedPaths;
    }
}

