/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.admin.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.polaris.core.admin.model.AwsStorageConfigInfo;
import org.apache.polaris.core.admin.model.AzureStorageConfigInfo;
import org.apache.polaris.core.admin.model.FileStorageConfigInfo;
import org.apache.polaris.core.admin.model.GcpStorageConfigInfo;

@ApiModel(description="A storage configuration used by catalogs")
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="storageType", visible=true)
@JsonSubTypes(value={@JsonSubTypes.Type(value=AzureStorageConfigInfo.class, name="AZURE"), @JsonSubTypes.Type(value=FileStorageConfigInfo.class, name="FILE"), @JsonSubTypes.Type(value=GcpStorageConfigInfo.class, name="GCS"), @JsonSubTypes.Type(value=AwsStorageConfigInfo.class, name="S3")})
public class StorageConfigInfo {
    @NotNull
    private final StorageTypeEnum storageType;
    private final List<String> allowedLocations;

    @ApiModelProperty(required=true, value="The cloud provider type this storage is built on. FILE is supported for testing purposes only")
    @JsonProperty(value="storageType", required=true)
    public StorageTypeEnum getStorageType() {
        return this.storageType;
    }

    @ApiModelProperty(example="For AWS [s3://bucketname/prefix/], for AZURE [abfss://container@storageaccount.blob.core.windows.net/prefix/], for GCP [gs://bucketname/prefix/]", value="")
    @JsonProperty(value="allowedLocations")
    public List<String> getAllowedLocations() {
        return this.allowedLocations;
    }

    @JsonCreator
    public StorageConfigInfo(@JsonProperty(value="storageType", required=true) StorageTypeEnum storageType, @JsonProperty(value="allowedLocations") List<String> allowedLocations) {
        this.storageType = storageType;
        this.allowedLocations = Objects.requireNonNullElse(allowedLocations, new ArrayList());
    }

    public StorageConfigInfo(StorageTypeEnum storageType) {
        this.storageType = storageType;
        this.allowedLocations = new ArrayList<String>();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StorageConfigInfo storageConfigInfo = (StorageConfigInfo)o;
        return Objects.equals((Object)this.storageType, (Object)storageConfigInfo.storageType) && Objects.equals(this.allowedLocations, storageConfigInfo.allowedLocations);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.storageType, this.allowedLocations});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class StorageConfigInfo {\n");
        sb.append("    storageType: ").append(this.toIndentedString((Object)this.storageType)).append("\n");
        sb.append("    allowedLocations: ").append(this.toIndentedString(this.allowedLocations)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StorageTypeEnum {
        S3("S3"),
        GCS("GCS"),
        AZURE("AZURE"),
        FILE("FILE");

        private String value;

        private StorageTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static final class Builder {
        private StorageTypeEnum storageType;
        private List<String> allowedLocations;

        private Builder() {
        }

        private Builder(StorageTypeEnum storageType) {
            this.storageType = storageType;
        }

        public Builder setStorageType(StorageTypeEnum storageType) {
            this.storageType = storageType;
            return this;
        }

        public Builder setAllowedLocations(List<String> allowedLocations) {
            this.allowedLocations = allowedLocations;
            return this;
        }

        public StorageConfigInfo build() {
            StorageConfigInfo inst = new StorageConfigInfo(this.storageType, this.allowedLocations);
            return inst;
        }
    }
}

