/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.map;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class RegexMapper<K>
extends Mapper<K, Text, Text, LongWritable> {
    public static String PATTERN = "mapreduce.mapper.regex";
    public static String GROUP = "mapreduce.mapper.regexmapper..group";
    private Pattern pattern;
    private int group;

    @Override
    public void setup(Mapper.Context context) {
        Configuration conf = context.getConfiguration();
        this.pattern = Pattern.compile(conf.get(PATTERN));
        this.group = conf.getInt(GROUP, 0);
    }

    @Override
    public void map(K key, Text value, Mapper.Context context) throws IOException, InterruptedException {
        String text = value.toString();
        Matcher matcher = this.pattern.matcher(text);
        while (matcher.find()) {
            context.write(new Text(matcher.group(this.group)), new LongWritable(1L));
        }
    }
}

