/*
 * Decompiled with CFR 0.152.
 */
package org.apache.livy.thriftserver;

import java.security.PrivilegedExceptionAction;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hive.service.cli.FetchOrientation;
import org.apache.hive.service.cli.HiveSQLException;
import org.apache.hive.service.cli.OperationState;
import org.apache.hive.service.cli.OperationType;
import org.apache.hive.service.cli.SessionHandle;
import org.apache.livy.thriftserver.LivyExecuteStatementOperation$;
import org.apache.livy.thriftserver.LivyThriftSessionManager;
import org.apache.livy.thriftserver.SessionInfo;
import org.apache.livy.thriftserver.SessionStates$;
import org.apache.livy.thriftserver.ThriftServerAudit$;
import org.apache.livy.thriftserver.operation.Operation;
import org.apache.livy.thriftserver.rpc.RpcClient;
import org.apache.livy.thriftserver.serde.ThriftResultSet;
import org.apache.livy.thriftserver.serde.ThriftResultSet$;
import org.apache.livy.thriftserver.session.ResultSet;
import org.apache.livy.thriftserver.types.BasicDataType;
import org.apache.livy.thriftserver.types.DataTypeUtils$;
import org.apache.livy.thriftserver.types.Field;
import org.apache.livy.thriftserver.types.Schema;
import org.apache.livy.thriftserver.types.Schema$;
import scala.Enumeration;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005Me\u0001B\u0001\u0003\u0001-\u0011Q\u0004T5ws\u0016CXmY;uKN#\u0018\r^3nK:$x\n]3sCRLwN\u001c\u0006\u0003\u0007\u0011\tA\u0002\u001e5sS\u001a$8/\u001a:wKJT!!\u0002\u0004\u0002\t1Lg/\u001f\u0006\u0003\u000f!\ta!\u00199bG\",'\"A\u0005\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001a!\u0003\u0005\u0002\u000e!5\taB\u0003\u0002\u0010\u0005\u0005Iq\u000e]3sCRLwN\\\u0005\u0003#9\u0011\u0011b\u00149fe\u0006$\u0018n\u001c8\u0011\u0005M!R\"\u0001\u0003\n\u0005U!!a\u0002'pO\u001eLgn\u001a\u0005\n/\u0001\u0011\t\u0011)A\u00051\t\nQb]3tg&|g\u000eS1oI2,\u0007CA\r!\u001b\u0005Q\"BA\u000e\u001d\u0003\r\u0019G.\u001b\u0006\u0003;y\tqa]3sm&\u001cWM\u0003\u0002 \r\u0005!\u0001.\u001b<f\u0013\t\t#DA\u0007TKN\u001c\u0018n\u001c8IC:$G.Z\u0005\u0003/AA\u0001\u0002\n\u0001\u0003\u0002\u0003\u0006I!J\u0001\ngR\fG/Z7f]R\u0004\"A\n\u0017\u000f\u0005\u001dRS\"\u0001\u0015\u000b\u0003%\nQa]2bY\u0006L!a\u000b\u0015\u0002\rA\u0013X\rZ3g\u0013\ticF\u0001\u0004TiJLgn\u001a\u0006\u0003W!B\u0001\u0002\r\u0001\u0003\u0002\u0003\u0006I!M\u0001\u0010eVt\u0017J\u001c\"bG.<'o\\;oIB\u0011qEM\u0005\u0003g!\u0012qAQ8pY\u0016\fg\u000e\u0003\u00056\u0001\t\u0005\t\u0015!\u00037\u00039\u0019Xm]:j_:l\u0015M\\1hKJ\u0004\"a\u000e\u001d\u000e\u0003\tI!!\u000f\u0002\u000311Kg/\u001f+ie&4GoU3tg&|g.T1oC\u001e,'\u000fC\u0003<\u0001\u0011\u0005A(\u0001\u0004=S:LGO\u0010\u000b\u0006{yz\u0004)\u0011\t\u0003o\u0001AQa\u0006\u001eA\u0002aAQ\u0001\n\u001eA\u0002\u0015Bq\u0001\r\u001e\u0011\u0002\u0003\u0007\u0011\u0007C\u00036u\u0001\u0007a\u0007C\u0004D\u0001\t\u0007I\u0011\u0002#\u0002#=\u0004XM]1uS>tW*Z:tC\u001e,7/F\u0001F!\r1U*J\u0007\u0002\u000f*\u0011\u0001*S\u0001\u000bG>t7-\u001e:sK:$(B\u0001&L\u0003\u0011)H/\u001b7\u000b\u00031\u000bAA[1wC&\u0011aj\u0012\u0002\u0016\u0007>t7-\u001e:sK:$H*\u001b8lK\u0012\fV/Z;f\u0011\u0019\u0001\u0006\u0001)A\u0005\u000b\u0006\u0011r\u000e]3sCRLwN\\'fgN\fw-Z:!\u0011!\u0011\u0006\u0001#b\u0001\n\u0013\u0019\u0016!\u0003:qG\u000ec\u0017.\u001a8u+\u0005!\u0006CA+Y\u001b\u00051&BA,\u0003\u0003\r\u0011\boY\u0005\u00033Z\u0013\u0011B\u00159d\u00072LWM\u001c;\t\u0011m\u0003\u0001\u0012!Q!\nQ\u000b!B\u001d9d\u00072LWM\u001c;!\u0011\u001di\u0006\u00011A\u0005\ny\u000b\u0011B]8x\u001f\u001a47/\u001a;\u0016\u0003}\u0003\"a\n1\n\u0005\u0005D#\u0001\u0002'p]\u001eDqa\u0019\u0001A\u0002\u0013%A-A\u0007s_^|eMZ:fi~#S-\u001d\u000b\u0003K\"\u0004\"a\n4\n\u0005\u001dD#\u0001B+oSRDq!\u001b2\u0002\u0002\u0003\u0007q,A\u0002yIEBaa\u001b\u0001!B\u0013y\u0016A\u0003:po>3gm]3uA!)Q\u000e\u0001C\u0005]\u0006Y1\u000f^1uK6,g\u000e^%e+\u0005)\u0003\"\u00029\u0001\t\u0013\t\u0018A\u0004:qG\u000ec\u0017.\u001a8u-\u0006d\u0017\u000eZ\u000b\u0002c!)1\u000f\u0001C!i\u0006iq-\u001a;OKb$(k\\<TKR$B!^>\u0002\u0002A\u0011a/_\u0007\u0002o*\u0011\u0001PA\u0001\u0006g\u0016\u0014H-Z\u0005\u0003u^\u0014q\u0002\u00165sS\u001a$(+Z:vYR\u001cV\r\u001e\u0005\u0006yJ\u0004\r!`\u0001\u0006_J$WM\u001d\t\u00033yL!a \u000e\u0003!\u0019+Go\u00195Pe&,g\u000e^1uS>t\u0007BBA\u0002e\u0002\u0007q,\u0001\u0005nCb\u0014vn^:M\u0011\u001d\t9\u0001\u0001C!\u0003\u0013\t1B];o\u0013:$XM\u001d8bYR\tQ\rC\u0004\u0002\u000e\u0001!\t\"!\u0003\u0002\u000f\u0015DXmY;uK\"9\u0011\u0011\u0003\u0001\u0005\u0002\u0005%\u0011!B2m_N,\u0007bBA\u000b\u0001\u0011\u0005\u0013qC\u0001\u0007G\u0006t7-\u001a7\u0015\u0007\u0015\fI\u0002\u0003\u0005\u0002\u001c\u0005M\u0001\u0019AA\u000f\u0003\u0015\u0019H/\u0019;f!\rI\u0012qD\u0005\u0004\u0003CQ\"AD(qKJ\fG/[8o'R\fG/\u001a\u0005\u0007\u0003K\u0001A\u0011I9\u0002\u001dMDw.\u001e7e%Vt\u0017i]=oG\"9\u0011\u0011\u0006\u0001\u0005B\u0005-\u0012AE4fiJ+7/\u001e7u'\u0016$8k\u00195f[\u0006,\"!!\f\u0011\t\u0005=\u0012QG\u0007\u0003\u0003cQ1!a\r\u0003\u0003\u0015!\u0018\u0010]3t\u0013\u0011\t9$!\r\u0003\rM\u001b\u0007.Z7b\u0011\u001d\tY\u0004\u0001C\u0005\u0003{\tqa\u00197fC:,\b\u000fF\u0002f\u0003\u007fA\u0001\"a\u0007\u0002:\u0001\u0007\u0011Q\u0004\u0005\b\u0003\u0007\u0002A\u0011AA#\u0003Q9W\r^(qKJ\fG/[8o\u001b\u0016\u001c8/Y4fgV\u0011\u0011q\t\t\u0006\u0003\u0013\nI&\n\b\u0005\u0003\u0017\n)F\u0004\u0003\u0002N\u0005MSBAA(\u0015\r\t\tFC\u0001\u0007yI|w\u000e\u001e \n\u0003%J1!a\u0016)\u0003\u001d\u0001\u0018mY6bO\u0016LA!a\u0017\u0002^\t\u00191+Z9\u000b\u0007\u0005]\u0003\u0006C\u0007\u0002b\u0001\u0001\n1!A\u0001\n\u0013\t\u0019GI\u0001\u0014gV\u0004XM\u001d\u0013tKN\u001c\u0018n\u001c8IC:$G.Z\u000b\u00021\u001dI\u0011q\r\u0002\u0002\u0002#\u0005\u0011\u0011N\u0001\u001e\u0019&4\u00180\u0012=fGV$Xm\u0015;bi\u0016lWM\u001c;Pa\u0016\u0014\u0018\r^5p]B\u0019q'a\u001b\u0007\u0011\u0005\u0011\u0011\u0011!E\u0001\u0003[\u001aB!a\u001b\u0002pA\u0019q%!\u001d\n\u0007\u0005M\u0004F\u0001\u0004B]f\u0014VM\u001a\u0005\bw\u0005-D\u0011AA<)\t\tI\u0007\u0003\u0006\u0002|\u0005-\u0014\u0013!C\u0001\u0003{\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u001aTCAA@U\r\t\u0014\u0011Q\u0016\u0003\u0003\u0007\u0003B!!\"\u0002\u00106\u0011\u0011q\u0011\u0006\u0005\u0003\u0013\u000bY)A\u0005v]\u000eDWmY6fI*\u0019\u0011Q\u0012\u0015\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\u0012\u0006\u001d%!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0002")
public class LivyExecuteStatementOperation
extends Operation {
    public final String org$apache$livy$thriftserver$LivyExecuteStatementOperation$$statement;
    private final boolean runInBackground;
    private final LivyThriftSessionManager sessionManager;
    private final ConcurrentLinkedQueue<String> operationMessages;
    private RpcClient rpcClient;
    private long rowOffset;
    private volatile boolean bitmap$0;

    public static boolean $lessinit$greater$default$3() {
        return LivyExecuteStatementOperation$.MODULE$.$lessinit$greater$default$3();
    }

    private RpcClient rpcClient$lzycompute() {
        LivyExecuteStatementOperation livyExecuteStatementOperation = this;
        synchronized (livyExecuteStatementOperation) {
            if (!this.bitmap$0) {
                Enumeration.Value sessionState;
                Enumeration.Value value = sessionState = this.sessionManager.livySessionState(super.sessionHandle());
                Enumeration.Value value2 = SessionStates$.MODULE$.CREATION_IN_PROGRESS();
                Object object = !(value != null ? !value.equals(value2) : value2 != null) ? BoxesRunTime.boxToBoolean((boolean)this.operationMessages().offer("Livy session has not yet started. Please wait for it to be ready...")) : BoxedUnit.UNIT;
                this.rpcClient = new RpcClient(this.sessionManager.getLivySession(super.sessionHandle()));
                this.bitmap$0 = true;
            }
            return this.rpcClient;
        }
    }

    public /* synthetic */ SessionHandle org$apache$livy$thriftserver$LivyExecuteStatementOperation$$super$sessionHandle() {
        return super.sessionHandle();
    }

    private ConcurrentLinkedQueue<String> operationMessages() {
        return this.operationMessages;
    }

    private RpcClient rpcClient() {
        return this.bitmap$0 ? this.rpcClient : this.rpcClient$lzycompute();
    }

    private long rowOffset() {
        return this.rowOffset;
    }

    private void rowOffset_$eq(long x$1) {
        this.rowOffset = x$1;
    }

    public String org$apache$livy$thriftserver$LivyExecuteStatementOperation$$statementId() {
        return this.opHandle().getHandleIdentifier().toString();
    }

    private boolean rpcClientValid() {
        Enumeration.Value value = this.sessionManager.livySessionState(super.sessionHandle());
        Enumeration.Value value2 = SessionStates$.MODULE$.CREATION_SUCCESS();
        return !(value != null ? !value.equals(value2) : value2 != null) && this.rpcClient().isValid();
    }

    @Override
    public ThriftResultSet getNextRowSet(FetchOrientation order, long maxRowsL) {
        this.validateFetchOrientation(order);
        this.assertState((Seq<OperationState>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new OperationState[]{OperationState.FINISHED}))));
        this.setHasResultSet(true);
        int maxRows = (int)maxRowsL;
        ResultSet resultSet = (ResultSet)this.rpcClient().fetchResult(super.sessionHandle(), this.org$apache$livy$thriftserver$LivyExecuteStatementOperation$$statementId(), maxRows).get();
        ThriftResultSet livyColumnResultSet = ThriftResultSet$.MODULE$.apply(resultSet);
        livyColumnResultSet.setRowOffset(this.rowOffset());
        this.rowOffset_$eq(this.rowOffset() + (long)livyColumnResultSet.numRows());
        return livyColumnResultSet;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void runInternal() {
        this.setState(OperationState.PENDING);
        this.setHasResultSet(true);
        if (!this.runInBackground) {
            this.execute();
            return;
        }
        UserGroupInformation livyServiceUGI = UserGroupInformation.getCurrentUser();
        Runnable backgroundOperation = new Runnable(this, livyServiceUGI){
            private final /* synthetic */ LivyExecuteStatementOperation $outer;
            public final UserGroupInformation livyServiceUGI$1;

            public void run() {
                PrivilegedExceptionAction<BoxedUnit> doAsAction = new PrivilegedExceptionAction<BoxedUnit>(this){
                    private final /* synthetic */ $anon$1 $outer;

                    public void run() {
                        try {
                            this.$outer.org$apache$livy$thriftserver$LivyExecuteStatementOperation$$anon$$$outer().execute();
                        }
                        catch (HiveSQLException hiveSQLException) {
                            this.$outer.org$apache$livy$thriftserver$LivyExecuteStatementOperation$$anon$$$outer().setOperationException(hiveSQLException);
                            this.$outer.org$apache$livy$thriftserver$LivyExecuteStatementOperation$$anon$$$outer().error((Function0<Object>)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final String apply() {
                                    return "Error running hive query: ";
                                }
                            }, hiveSQLException);
                        }
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                };
                try {
                    this.livyServiceUGI$1.doAs((PrivilegedExceptionAction)doAsAction);
                }
                catch (Exception exception) {
                    this.$outer.setOperationException(new HiveSQLException((Throwable)exception));
                    this.$outer.error((Function0<Object>)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anon$1 $outer;

                        public final String apply() {
                            return new StringBuilder().append((Object)"Error running hive query as user : ").append((Object)this.$outer.livyServiceUGI$1.getShortUserName()).toString();
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }, exception);
                }
            }

            public /* synthetic */ LivyExecuteStatementOperation org$apache$livy$thriftserver$LivyExecuteStatementOperation$$anon$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.livyServiceUGI$1 = livyServiceUGI$1;
            }
        };
        try {
            Future<?> backgroundHandle = this.sessionManager.submitBackgroundOperation(backgroundOperation);
            this.setBackgroundHandle(backgroundHandle);
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof RejectedExecutionException) {
                RejectedExecutionException rejectedExecutionException = (RejectedExecutionException)throwable2;
                this.setState(OperationState.ERROR);
                throw new HiveSQLException("The background threadpool cannot accept new task for execution, please retry the operation", (Throwable)rejectedExecutionException);
            }
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            this.error((Function0<Object>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error executing query in background"})).s((Seq)Nil$.MODULE$);
                }
            }, e);
            this.setState(OperationState.ERROR);
            throw e;
        }
    }

    public void execute() {
        if (this.logger().isDebugEnabled()) {
            this.debug((Function0<Object>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ LivyExecuteStatementOperation $outer;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Running query '", "' with id ", " (session = "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$livy$thriftserver$LivyExecuteStatementOperation$$statement, this.$outer.org$apache$livy$thriftserver$LivyExecuteStatementOperation$$statementId()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$livy$thriftserver$LivyExecuteStatementOperation$$super$sessionHandle().getSessionId()}))).toString();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
        }
        this.setState(OperationState.RUNNING);
        long before = System.currentTimeMillis();
        try {
            this.rpcClient().executeSql(super.sessionHandle(), this.org$apache$livy$thriftserver$LivyExecuteStatementOperation$$statementId(), this.org$apache$livy$thriftserver$LivyExecuteStatementOperation$$statement).get();
        }
        catch (Throwable throwable) {
            OperationState currentState = this.getStatus().state();
            this.info((Function0<Object>)new Serializable(this, throwable, currentState){
                public static final long serialVersionUID = 0L;
                private final Throwable e$1;
                private final OperationState currentState$1;

                public final Tuple2<String, Throwable> apply() {
                    return new Tuple2((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error executing query, currentState ", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.currentState$1})), (Object)this.e$1);
                }
                {
                    this.e$1 = e$1;
                    this.currentState$1 = currentState$1;
                }
            });
            this.setState(OperationState.ERROR);
            throw new HiveSQLException(throwable);
        }
        this.setState(OperationState.FINISHED);
        SessionInfo sessionInfo = this.sessionManager.getSessionInfo(super.sessionHandle());
        long after = System.currentTimeMillis();
        ThriftServerAudit$.MODULE$.audit(sessionInfo.username(), sessionInfo.ipAddress(), this.org$apache$livy$thriftserver$LivyExecuteStatementOperation$$statement, before, after);
    }

    @Override
    public void close() {
        this.info((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LivyExecuteStatementOperation $outer;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Close ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$livy$thriftserver$LivyExecuteStatementOperation$$statementId()}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.cleanup(OperationState.CLOSED);
    }

    @Override
    public void cancel(OperationState state) {
        this.info((Function0<Object>)new Serializable(this, state){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LivyExecuteStatementOperation $outer;
            private final OperationState state$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cancel ", " with state ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$livy$thriftserver$LivyExecuteStatementOperation$$statementId(), this.state$1}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.state$1 = state$1;
            }
        });
        this.cleanup(state);
    }

    @Override
    public boolean shouldRunAsync() {
        return this.runInBackground;
    }

    @Override
    public Schema getResultSetSchema() {
        Schema tableSchema = DataTypeUtils$.MODULE$.schemaFromSparkJson((String)this.rpcClient().fetchResultSchema(super.sessionHandle(), this.org$apache$livy$thriftserver$LivyExecuteStatementOperation$$statementId()).get());
        return Predef$.MODULE$.refArrayOps((Object[])tableSchema.fields()).isEmpty() ? Schema$.MODULE$.apply((Seq<Field>)Predef$.MODULE$.wrapRefArray((Object[])new Field[]{new Field("Result", new BasicDataType("string"), "")})) : tableSchema;
    }

    private void cleanup(OperationState state) {
        Boolean cleaned;
        if (this.org$apache$livy$thriftserver$LivyExecuteStatementOperation$$statementId() != null && this.rpcClientValid() && !Predef$.MODULE$.Boolean2boolean(cleaned = (Boolean)this.rpcClient().cleanupStatement(super.sessionHandle(), this.org$apache$livy$thriftserver$LivyExecuteStatementOperation$$statementId(), this.rpcClient().cleanupStatement$default$3()).get())) {
            this.warn((Function0<Object>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ LivyExecuteStatementOperation $outer;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Fail to cleanup query ", " (session = ", "), "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$livy$thriftserver$LivyExecuteStatementOperation$$statementId(), this.$outer.org$apache$livy$thriftserver$LivyExecuteStatementOperation$$super$sessionHandle().getSessionId()}))).append((Object)"this message can be ignored if the query failed.").toString();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
        }
        this.setState(state);
    }

    /*
     * WARNING - void declaration
     */
    public Seq<String> getOperationMessages() {
        void var1_1;
        ListBuffer res = new ListBuffer();
        while (this.fetchNext$1(res)) {
        }
        return var1_1;
    }

    private final boolean fetchNext$1(ListBuffer acc) {
        boolean bl;
        String m = this.operationMessages().poll();
        if (m == null) {
            bl = false;
        } else {
            acc.$plus$eq((Object)m);
            bl = true;
        }
        return bl;
    }

    public LivyExecuteStatementOperation(SessionHandle sessionHandle, String statement, boolean runInBackground, LivyThriftSessionManager sessionManager) {
        this.org$apache$livy$thriftserver$LivyExecuteStatementOperation$$statement = statement;
        this.runInBackground = runInBackground;
        this.sessionManager = sessionManager;
        super(sessionHandle, OperationType.EXECUTE_STATEMENT);
        this.operationMessages = new ConcurrentLinkedQueue();
        this.rowOffset = 0L;
    }
}

