/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoContiguous;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoContiguousUnderConstruction;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;

@InterfaceAudience.Private
public class FileUnderConstructionFeature
implements INode.Feature {
    private String clientName;
    private final String clientMachine;

    public FileUnderConstructionFeature(String clientName, String clientMachine) {
        this.clientName = clientName;
        this.clientMachine = clientMachine;
    }

    public String getClientName() {
        return this.clientName;
    }

    void setClientName(String clientName) {
        this.clientName = clientName;
    }

    public String getClientMachine() {
        return this.clientMachine;
    }

    void updateLengthOfLastBlock(INodeFile f, long lastBlockLength) throws IOException {
        BlockInfoContiguous lastBlock = f.getLastBlock();
        assert (lastBlock != null) : "The last block for path " + f.getFullPathName() + " is null when updating its length";
        assert (lastBlock instanceof BlockInfoContiguousUnderConstruction) : "The last block for path " + f.getFullPathName() + " is not a BlockInfoUnderConstruction when updating its length";
        lastBlock.setNumBytes(lastBlockLength);
    }

    void cleanZeroSizeBlock(INodeFile f, INode.BlocksMapUpdateInfo collectedBlocks) {
        BlockInfoContiguousUnderConstruction lastUC;
        BlockInfoContiguous[] blocks = f.getBlocks();
        if (blocks != null && blocks.length > 0 && blocks[blocks.length - 1] instanceof BlockInfoContiguousUnderConstruction && (lastUC = (BlockInfoContiguousUnderConstruction)blocks[blocks.length - 1]).getNumBytes() == 0L) {
            collectedBlocks.addDeleteBlock(lastUC);
            f.removeLastBlock(lastUC);
        }
    }
}

