/*
 * Decompiled with CFR 0.152.
 */
package org.apache.livy.thriftserver.session;

import java.util.Iterator;
import org.apache.livy.Job;
import org.apache.livy.JobContext;
import org.apache.livy.thriftserver.session.ResultSet;
import org.apache.livy.thriftserver.session.StatementState;
import org.apache.livy.thriftserver.session.ThriftSessionState;
import org.apache.spark.sql.Row;

public class FetchResultJob
implements Job<ResultSet> {
    private final String sessionId;
    private final String statementId;
    private final int maxRows;

    public FetchResultJob() {
        this(null, null, -1);
    }

    public FetchResultJob(String sessionId, String statementId, int maxRows) {
        this.sessionId = sessionId;
        this.statementId = statementId;
        this.maxRows = maxRows;
    }

    public ResultSet call(JobContext ctx) {
        ThriftSessionState session = ThriftSessionState.get(ctx, this.sessionId);
        StatementState st = session.findStatement(this.statementId);
        Iterator<Row> iter = st.iter;
        ResultSet rs = new ResultSet(st.types, st.schema);
        for (int count = 0; iter.hasNext() && count < this.maxRows; ++count) {
            Row row = iter.next();
            Object[] cols = new Object[st.types.length];
            for (int i = 0; i < cols.length; ++i) {
                cols[i] = row.get(i);
            }
            rs.addRow(cols);
        }
        return rs;
    }
}

