/*
 * Decompiled with CFR 0.152.
 */
package org.apache.livy.server.recovery;

import java.util.List;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.UnhandledErrorListener;
import org.apache.curator.retry.RetryNTimes;
import org.apache.livy.LivyConf;
import org.apache.livy.LivyConf$;
import org.apache.livy.Logging;
import org.apache.livy.server.recovery.StateStore;
import org.apache.livy.server.recovery.ZooKeeperStateStore$;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.JavaConverters$;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001\u0005Ev!B\u0001\u0003\u0011\u0003i\u0011a\u0005.p_.+W\r]3s'R\fG/Z*u_J,'BA\u0002\u0005\u0003!\u0011XmY8wKJL(BA\u0003\u0007\u0003\u0019\u0019XM\u001d<fe*\u0011q\u0001C\u0001\u0005Y&4\u0018P\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7\u0001\u0001\t\u0003\u001d=i\u0011A\u0001\u0004\u0006!\tA\t!\u0005\u0002\u00145>|7*Z3qKJ\u001cF/\u0019;f'R|'/Z\n\u0003\u001fI\u0001\"a\u0005\f\u000e\u0003QQ\u0011!F\u0001\u0006g\u000e\fG.Y\u0005\u0003/Q\u0011a!\u00118z%\u00164\u0007\"B\r\u0010\t\u0003Q\u0012A\u0002\u001fj]&$h\bF\u0001\u000e\u0011\u001darB1A\u0005\u0002u\t!CW&`\u0017\u0016Kv\f\u0015*F\r&CvlQ(O\rV\ta\u0004\u0005\u0002 W9\u0011\u0001%\u000b\b\u0003C!r!AI\u0014\u000f\u0005\r2S\"\u0001\u0013\u000b\u0005\u0015b\u0011A\u0002\u001fs_>$h(C\u0001\f\u0013\tI!\"\u0003\u0002\b\u0011%\u0011!FB\u0001\t\u0019&4\u0018pQ8oM&\u0011A&\f\u0002\u0006\u000b:$(/\u001f\u0006\u0003U\u0019AaaL\b!\u0002\u0013q\u0012a\u0005.L?.+\u0015l\u0018)S\u000b\u001aK\u0005lX\"P\u001d\u001a\u0003\u0003bB\u0019\u0010\u0005\u0004%\t!H\u0001\u000e5.{&+\u0012+S3~\u001buJ\u0014$\t\rMz\u0001\u0015!\u0003\u001f\u00039Q6j\u0018*F)JKvlQ(O\r\u0002Bq!N\b\u0012\u0002\u0013\u0005a'A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HEM\u000b\u0002o)\u0012\u0001h\u0011\t\u0004'eZ\u0014B\u0001\u001e\u0015\u0005\u0019y\u0005\u000f^5p]B\u0011A(Q\u0007\u0002{)\u0011ahP\u0001\nMJ\fW.Z<pe.T!\u0001\u0011\u0005\u0002\u000f\r,(/\u0019;pe&\u0011!)\u0010\u0002\u0011\u0007V\u0014\u0018\r^8s\rJ\fW.Z<pe.\\\u0013\u0001\u0012\t\u0003\u000b*k\u0011A\u0012\u0006\u0003\u000f\"\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0005%#\u0012AC1o]>$\u0018\r^5p]&\u00111J\u0012\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,g\u0001\u0002\t\u0003\u00015\u001b2\u0001\u0014(R!\tqq*\u0003\u0002Q\u0005\tQ1\u000b^1uKN#xN]3\u0011\u0005I\u001bV\"\u0001\u0004\n\u0005Q3!a\u0002'pO\u001eLgn\u001a\u0005\t-2\u0013\t\u0011)A\u0005/\u0006AA.\u001b<z\u0007>tg\r\u0005\u0002S1&\u0011\u0011L\u0002\u0002\t\u0019&4\u0018pQ8oM\"A1\f\u0014B\u0001B\u0003%\u0001(A\tn_\u000e\\7)\u001e:bi>\u00148\t\\5f]RDQ!\u0007'\u0005\u0002u#2AX0a!\tqA\nC\u0003W9\u0002\u0007q\u000bC\u0004\\9B\u0005\t\u0019\u0001\u001d\t\u000beaE\u0011\u00012\u0015\u0005y\u001b\u0007\"\u0002,b\u0001\u00049\u0006bB3M\u0005\u0004%IAZ\u0001\nu.\fE\r\u001a:fgN,\u0012a\u001a\t\u0003Q6l\u0011!\u001b\u0006\u0003U.\fA\u0001\\1oO*\tA.\u0001\u0003kCZ\f\u0017B\u00018j\u0005\u0019\u0019FO]5oO\"1\u0001\u000f\u0014Q\u0001\n\u001d\f!B_6BI\u0012\u0014Xm]:!\u0011\u001d\u0011HJ1A\u0005\n\u0019\f1B_6LKf\u0004&/\u001a4jq\"1A\u000f\u0014Q\u0001\n\u001d\fAB_6LKf\u0004&/\u001a4jq\u0002BqA\u001e'C\u0002\u0013%a-\u0001\u0006sKR\u0014\u0018PV1mk\u0016Da\u0001\u001f'!\u0002\u00139\u0017a\u0003:fiJLh+\u00197vK\u0002BqA\u001f'C\u0002\u0013%10\u0001\u0007sKR\u0014\u0018\u0010U1ui\u0016\u0014h.F\u0001}!\ri\u0018QA\u0007\u0002}*\u0019q0!\u0001\u0002\u00115\fGo\u00195j]\u001eT1!a\u0001\u0015\u0003\u0011)H/\u001b7\n\u0007\u0005\u001daPA\u0003SK\u001e,\u0007\u0010C\u0004\u0002\f1\u0003\u000b\u0011\u0002?\u0002\u001bI,GO]=QCR$XM\u001d8!\u0011)\ty\u0001\u0014b\u0001\n\u0003\u0011\u0011\u0011C\u0001\fe\u0016$(/\u001f)pY&\u001c\u00170\u0006\u0002\u0002\u0014A!\u0011QCA\u000e\u001b\t\t9BC\u0002\u0002\u001a}\nQA]3uefLA!!\b\u0002\u0018\tY!+\u001a;ss:#\u0016.\\3t\u0011!\t\t\u0003\u0014Q\u0001\n\u0005M\u0011\u0001\u0004:fiJL\bk\u001c7jGf\u0004\u0003\"CA\u0013\u0019\n\u0007I\u0011BA\u0014\u00035\u0019WO]1u_J\u001cE.[3oiV\t1\bC\u0004\u0002,1\u0003\u000b\u0011B\u001e\u0002\u001d\r,(/\u0019;pe\u000ec\u0017.\u001a8uA!9\u0011q\u0006'\u0005B\u0005E\u0012aA:fiR1\u00111GA\u001d\u0003\u0013\u00022aEA\u001b\u0013\r\t9\u0004\u0006\u0002\u0005+:LG\u000f\u0003\u0005\u0002<\u00055\u0002\u0019AA\u001f\u0003\rYW-\u001f\t\u0005\u0003\u007f\t)ED\u0002\u0014\u0003\u0003J1!a\u0011\u0015\u0003\u0019\u0001&/\u001a3fM&\u0019a.a\u0012\u000b\u0007\u0005\rC\u0003\u0003\u0005\u0002L\u00055\u0002\u0019AA'\u0003\u00151\u0018\r\\;f!\rA\u0017qJ\u0005\u0004\u0003#J'AB(cU\u0016\u001cG\u000fC\u0004\u0002V1#\t%a\u0016\u0002\u0007\u001d,G/\u0006\u0003\u0002Z\u0005\rD\u0003BA.\u0003\u000b#B!!\u0018\u0002vA!1#OA0!\u0011\t\t'a\u0019\r\u0001\u0011A\u0011QMA*\u0005\u0004\t9GA\u0001U#\u0011\tI'a\u001c\u0011\u0007M\tY'C\u0002\u0002nQ\u0011qAT8uQ&tw\rE\u0002\u0014\u0003cJ1!a\u001d\u0015\u0005\r\te.\u001f\u0005\u000b\u0003o\n\u0019&!AA\u0004\u0005e\u0014AC3wS\u0012,gnY3%cA1\u00111PAA\u0003?j!!! \u000b\u0007\u0005}D#A\u0004sK\u001adWm\u0019;\n\t\u0005\r\u0015Q\u0010\u0002\t\u00072\f7o\u001d+bO\"A\u00111HA*\u0001\u0004\ti\u0004C\u0004\u0002\n2#\t%a#\u0002\u0017\u001d,Go\u00115jY\u0012\u0014XM\u001c\u000b\u0005\u0003\u001b\u000by\n\u0005\u0004\u0002\u0010\u0006e\u0015Q\b\b\u0005\u0003#\u000b)JD\u0002$\u0003'K\u0011!F\u0005\u0004\u0003/#\u0012a\u00029bG.\fw-Z\u0005\u0005\u00037\u000biJA\u0002TKFT1!a&\u0015\u0011!\tY$a\"A\u0002\u0005u\u0002bBAR\u0019\u0012\u0005\u0013QU\u0001\u0007e\u0016lwN^3\u0015\t\u0005M\u0012q\u0015\u0005\t\u0003w\t\t\u000b1\u0001\u0002>!9\u00111\u0016'\u0005\n\u00055\u0016!\u00039sK\u001aL\u0007pS3z)\u0011\ti$a,\t\u0011\u0005m\u0012\u0011\u0016a\u0001\u0003{\u0001")
public class ZooKeeperStateStore
extends StateStore
implements Logging {
    private final String org$apache$livy$server$recovery$ZooKeeperStateStore$$zkAddress;
    private final String zkKeyPrefix;
    private final String retryValue;
    private final Regex retryPattern;
    private final RetryNTimes retryPolicy;
    private final CuratorFramework org$apache$livy$server$recovery$ZooKeeperStateStore$$curatorClient;
    private final Logger logger;
    private volatile boolean bitmap$0;

    public static Option<CuratorFramework> $lessinit$greater$default$2() {
        return ZooKeeperStateStore$.MODULE$.$lessinit$greater$default$2();
    }

    public static LivyConf.Entry ZK_RETRY_CONF() {
        return ZooKeeperStateStore$.MODULE$.ZK_RETRY_CONF();
    }

    public static LivyConf.Entry ZK_KEY_PREFIX_CONF() {
        return ZooKeeperStateStore$.MODULE$.ZK_KEY_PREFIX_CONF();
    }

    private Logger logger$lzycompute() {
        ZooKeeperStateStore zooKeeperStateStore = this;
        synchronized (zooKeeperStateStore) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public void trace(Function0<Object> message) {
        Logging.class.trace((Logging)this, message);
    }

    @Override
    public void debug(Function0<Object> message) {
        Logging.class.debug((Logging)this, message);
    }

    @Override
    public void info(Function0<Object> message) {
        Logging.class.info((Logging)this, message);
    }

    @Override
    public void warn(Function0<Object> message) {
        Logging.class.warn((Logging)this, message);
    }

    @Override
    public void error(Function0<Object> message, Throwable t) {
        Logging.class.error((Logging)this, message, (Throwable)t);
    }

    @Override
    public void error(Function0<Object> message) {
        Logging.class.error((Logging)this, message);
    }

    public String org$apache$livy$server$recovery$ZooKeeperStateStore$$zkAddress() {
        return this.org$apache$livy$server$recovery$ZooKeeperStateStore$$zkAddress;
    }

    private String zkKeyPrefix() {
        return this.zkKeyPrefix;
    }

    private String retryValue() {
        return this.retryValue;
    }

    private Regex retryPattern() {
        return this.retryPattern;
    }

    public RetryNTimes retryPolicy() {
        return this.retryPolicy;
    }

    public CuratorFramework org$apache$livy$server$recovery$ZooKeeperStateStore$$curatorClient() {
        return this.org$apache$livy$server$recovery$ZooKeeperStateStore$$curatorClient;
    }

    @Override
    public void set(String key, Object value) {
        String prefixedKey = this.prefixKey(key);
        byte[] data = this.serializeToBytes(value);
        if (this.org$apache$livy$server$recovery$ZooKeeperStateStore$$curatorClient().checkExists().forPath(prefixedKey) == null) {
            this.org$apache$livy$server$recovery$ZooKeeperStateStore$$curatorClient().create().creatingParentsIfNeeded().forPath(prefixedKey, data);
        } else {
            this.org$apache$livy$server$recovery$ZooKeeperStateStore$$curatorClient().setData().forPath(prefixedKey, data);
        }
    }

    @Override
    public <T> Option<T> get(String key, ClassTag<T> evidence$1) {
        String prefixedKey = this.prefixKey(key);
        return this.org$apache$livy$server$recovery$ZooKeeperStateStore$$curatorClient().checkExists().forPath(prefixedKey) == null ? None$.MODULE$ : Option$.MODULE$.apply(this.deserialize((byte[])this.org$apache$livy$server$recovery$ZooKeeperStateStore$$curatorClient().getData().forPath(prefixedKey), evidence$1));
    }

    @Override
    public Seq<String> getChildren(String key) {
        String prefixedKey = this.prefixKey(key);
        return this.org$apache$livy$server$recovery$ZooKeeperStateStore$$curatorClient().checkExists().forPath(prefixedKey) == null ? (Seq)Seq$.MODULE$.empty() : (Seq)JavaConverters$.MODULE$.asScalaBufferConverter((List)this.org$apache$livy$server$recovery$ZooKeeperStateStore$$curatorClient().getChildren().forPath(prefixedKey)).asScala();
    }

    @Override
    public void remove(String key) {
        try {
            this.org$apache$livy$server$recovery$ZooKeeperStateStore$$curatorClient().delete().guaranteed().forPath(this.prefixKey(key));
        }
        catch (KeeperException.NoNodeException noNodeException) {}
    }

    private String prefixKey(String key) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"/", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.zkKeyPrefix(), key}));
    }

    public ZooKeeperStateStore(LivyConf livyConf, Option<CuratorFramework> mockCuratorClient) {
        super(livyConf);
        Logging.class.$init$((Logging)this);
        this.org$apache$livy$server$recovery$ZooKeeperStateStore$$zkAddress = livyConf.get(LivyConf$.MODULE$.RECOVERY_STATE_STORE_URL());
        Predef$.MODULE$.require(!this.org$apache$livy$server$recovery$ZooKeeperStateStore$$zkAddress().isEmpty(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Please config ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{LivyConf$.MODULE$.RECOVERY_STATE_STORE_URL().key()}));
            }
        });
        this.zkKeyPrefix = livyConf.get(ZooKeeperStateStore$.MODULE$.ZK_KEY_PREFIX_CONF());
        this.retryValue = livyConf.get(ZooKeeperStateStore$.MODULE$.ZK_RETRY_CONF());
        this.retryPattern = new StringOps(Predef$.MODULE$.augmentString("\\s*(\\d+)\\s*,\\s*(\\d+)\\s*")).r();
        String string = this.retryValue();
        Option option = this.retryPattern().unapplySeq((Object)string);
        if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(2) == 0) {
            RetryNTimes retryNTimes;
            String n = (String)((LinearSeqOptimized)option.get()).apply(0);
            String sleepMs = (String)((LinearSeqOptimized)option.get()).apply(1);
            this.retryPolicy = retryNTimes = new RetryNTimes(new StringOps(Predef$.MODULE$.augmentString(n)).toInt(), new StringOps(Predef$.MODULE$.augmentString(sleepMs)).toInt());
            this.org$apache$livy$server$recovery$ZooKeeperStateStore$$curatorClient = (CuratorFramework)mockCuratorClient.getOrElse((Function0)new $anonfun$2(this));
            Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(this){
                private final /* synthetic */ ZooKeeperStateStore $outer;

                public void run() {
                    this.$outer.org$apache$livy$server$recovery$ZooKeeperStateStore$$curatorClient().close();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            }));
            this.org$apache$livy$server$recovery$ZooKeeperStateStore$$curatorClient().getUnhandledErrorListenable().addListener((Object)new UnhandledErrorListener(this){
                private final /* synthetic */ ZooKeeperStateStore $outer;

                public void unhandledError(String message, Throwable e) {
                    this.$outer.error((Function0<Object>)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Fatal Zookeeper error. Shutting down Livy server."})).s((Seq)Nil$.MODULE$);
                        }
                    });
                    System.exit(1);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
            this.org$apache$livy$server$recovery$ZooKeeperStateStore$$curatorClient().start();
            return;
        }
        throw new IllegalArgumentException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " contains bad value: ", ". "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ZooKeeperStateStore$.MODULE$.ZK_KEY_PREFIX_CONF(), this.retryValue()}))).append((Object)"Correct format is <max retry count>,<sleep ms between retry>. e.g. 5,100").toString());
    }

    public ZooKeeperStateStore(LivyConf livyConf) {
        this(livyConf, (Option<CuratorFramework>)None$.MODULE$);
    }
}

