import { DmnUnitablesJsonSchemaBridge } from "./uniforms/DmnUnitablesJsonSchemaBridge";
import { DAYS_AND_TIME_DURATION_FORMAT, YEARS_AND_MONTHS_DURATION_FORMAT } from "@kie-tools/dmn-runner/dist/dmnFormats";
import { UnitablesValidator } from "@kie-tools/unitables/dist/UnitablesValidator";
import { DmnRunnerAjv } from "@kie-tools/dmn-runner/dist/ajv";
import { SCHEMA_DRAFT4 } from "@kie-tools/dmn-runner/dist/jsonSchemaConstants";
export class DmnUnitablesValidator extends UnitablesValidator {
    constructor(i18n) {
        super(i18n);
        this.dmnRunnerAjv = new DmnRunnerAjv();
    }
    createValidator(jsonSchema) {
        const validator = this.dmnRunnerAjv.getAjv().compile(jsonSchema);
        return (model) => {
            validator(JSON.parse(JSON.stringify(model)));
            if (validator.errors && validator.errors.length) {
                const details = validator.errors
                    .filter((error) => error.keyword !== "required")
                    .map((error) => {
                    if (error.keyword === "format") {
                        if (error.params.format === DAYS_AND_TIME_DURATION_FORMAT) {
                            return { ...error, message: "" };
                        }
                        if (error.params.format === YEARS_AND_MONTHS_DURATION_FORMAT) {
                            return { ...error, message: "" };
                        }
                    }
                });
                return { details };
            }
            return null;
        };
    }
    getBridge(formSchema) {
        const formDraft4 = { ...formSchema, $schema: SCHEMA_DRAFT4 };
        const validator = this.createValidator(formDraft4);
        return new DmnUnitablesJsonSchemaBridge(formDraft4, validator, this.i18n);
    }
}
//# sourceMappingURL=DmnUnitablesValidator.js.map