import { jsx as _jsx } from "react/jsx-runtime";
import { useEffect, useState } from "react";
import { Button } from "@patternfly/react-core/dist/js/components/";
import "./Toolbar.scss";
import { Split, SplitItem } from "@patternfly/react-core/dist/js/layouts/Split";
export const Toolbar = (props) => {
    const [previewButtonSelected, setPreviewButtonSelected] = useState(props.preview);
    useEffect(() => props.onPreviewChange(previewButtonSelected), [props, previewButtonSelected]);
    return (_jsx("div", { className: "toolbar ignore-onclickoutside", children: _jsx(Split, { hasGutter: true, children: _jsx(SplitItem, { children: _jsx(Button, { variant: "plain", style: { width: "auto", padding: "0px", textAlign: "left" }, onClick: (e) => {
                        setPreviewButtonSelected(!previewButtonSelected);
                    }, ouiaId: "preview-button", className: previewButtonSelected ? "selected" : "", children: "\uD83D\uDC41" }) }) }) }));
};
//# sourceMappingURL=Toolbar.js.map