import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import React from "react";
import { Label } from "@patternfly/react-core/dist/js/components/Label";
import { BanIcon } from "@patternfly/react-icons/dist/js/icons/ban-icon";
import { CheckCircleIcon } from "@patternfly/react-icons/dist/js/icons/check-circle-icon";
import { OnRunningIcon } from "@patternfly/react-icons/dist/js/icons/on-running-icon";
import { componentOuiaProps } from "@kie-tools/runtime-tools-components/dist/ouiaTools";
export const TaskState = ({ task, variant, ouiaId, ouiaSafe }) => {
    const icon = resolveTaskStateIcon(task);
    if (variant === "label") {
        const color = resolveTaskStateLabelColor(task);
        return (_jsx(Label, { color: color, icon: icon, ...componentOuiaProps(ouiaId, "task-state", ouiaSafe), children: task.state }));
    }
    return (_jsxs(React.Fragment, { children: [icon, " ", _jsx("span", { ...componentOuiaProps(ouiaId, "task-state", ouiaSafe), children: task.state })] }));
};
function resolveTaskStateIcon(task) {
    if (task.state === "Aborted") {
        return _jsx(BanIcon, { className: "pf-u-mr-sm" });
    }
    else if (task.completed) {
        return _jsx(CheckCircleIcon, { className: "pf-u-mr-sm", color: "var(--pf-global--success-color--100)" });
    }
    else {
        return _jsx(OnRunningIcon, { className: "pf-u-mr-sm" });
    }
}
function resolveTaskStateLabelColor(task) {
    if (task.state === "Aborted") {
        return "red";
    }
    else if (task.completed) {
        return "green";
    }
    else {
        return "blue";
    }
}
export default TaskState;
//# sourceMappingURL=TaskState.js.map