import { jsx as _jsx } from "react/jsx-runtime";
import React, { useCallback, useEffect, useState } from "react";
import { Bullseye } from "@patternfly/react-core/dist/js/layouts/Bullseye";
import CustomProcessFormDisplayer from "./CustomProcessFormDisplayer";
import { componentOuiaProps } from "@kie-tools/runtime-tools-components/dist/ouiaTools";
import { FormRenderer } from "@kie-tools/runtime-tools-components/dist/components/FormRenderer";
import { KogitoSpinner } from "@kie-tools/runtime-tools-components/dist/components/KogitoSpinner";
import { ServerErrors } from "@kie-tools/runtime-tools-components/dist/components/ServerErrors";
const ProcessForm = ({ processDefinition, driver, isEnvelopeConnectedToChannel, targetOrigin, ouiaId, ouiaSafe, }) => {
    const formRendererApi = React.useRef(null);
    const [processFormSchema, setProcessFormSchema] = useState({});
    const [processCustomForm, setProcessCustomForm] = useState();
    const [isLoading, setIsLoading] = useState(true);
    const [error, setError] = useState();
    const formAction = [
        {
            name: "Start",
        },
    ];
    const init = useCallback(async () => {
        if (!isEnvelopeConnectedToChannel) {
            return;
        }
        const customFormPromise = new Promise((resolve) => {
            driver
                .getCustomForm(processDefinition)
                .then((customForm) => {
                setProcessCustomForm(customForm);
                resolve();
            })
                .catch((error) => resolve());
        });
        const schemaPromise = new Promise((resolve, reject) => {
            driver
                .getProcessFormSchema(processDefinition)
                .then((schema) => {
                setProcessFormSchema(schema);
                resolve();
            })
                .catch((error) => {
                setError(error);
                reject(error);
            });
        });
        Promise.all([customFormPromise, schemaPromise]).finally(() => {
            setIsLoading(false);
        });
    }, [driver, isEnvelopeConnectedToChannel, processDefinition]);
    useEffect(() => {
        if (!isEnvelopeConnectedToChannel) {
            setIsLoading(true);
            return;
        }
        init();
    }, [init, isEnvelopeConnectedToChannel]);
    const onSubmit = (value) => {
        driver.startProcess(value).then(() => {
            var _a;
            (_a = formRendererApi === null || formRendererApi === void 0 ? void 0 : formRendererApi.current) === null || _a === void 0 ? void 0 : _a.doReset();
        });
    };
    if (isLoading) {
        return (_jsx(Bullseye, { children: _jsx(KogitoSpinner, { spinnerText: "Loading process forms...", ouiaId: "process-form-loading" }) }));
    }
    if (error) {
        return _jsx(ServerErrors, { error: error, variant: "large" });
    }
    if (!processCustomForm) {
        return (_jsx("div", { ...componentOuiaProps(ouiaId, "process-form", ouiaSafe ? ouiaSafe : !isLoading), children: _jsx(FormRenderer, { formSchema: processFormSchema, model: {}, readOnly: false, onSubmit: onSubmit, formActions: formAction, ref: formRendererApi }) }));
    }
    else {
        return (_jsx(CustomProcessFormDisplayer, { ...componentOuiaProps(ouiaId, "process-form", ouiaSafe ? ouiaSafe : !isLoading), schema: processFormSchema, customForm: processCustomForm, driver: driver, targetOrigin: targetOrigin }));
    }
};
export default ProcessForm;
//# sourceMappingURL=ProcessForm.js.map