import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { Card, CardBody, CardHeader } from "@patternfly/react-core/dist/js/components/Card";
import { Title } from "@patternfly/react-core/dist/js/components/Title";
import { TextContent } from "@patternfly/react-core/dist/js/components/Text";
import { Label } from "@patternfly/react-core/dist/js/components/Label";
import React, { useCallback, useMemo } from "react";
import ReactJson from "@microlink/react-json-view";
import { InfoCircleIcon } from "@patternfly/react-icons/dist/js/icons/info-circle-icon";
import "../styles.css";
import { ProcessInstanceState } from "@kie-tools/runtime-tools-process-gateway-api/dist/types";
import { componentOuiaProps } from "@kie-tools/runtime-tools-components/dist/ouiaTools";
const ProcessVariables = ({ displayLabel, displaySuccess, ouiaId, ouiaSafe, setDisplayLabel, setUpdateJson, updateJson, processInstance, }) => {
    const handleVariablesChange = useCallback((e) => {
        setUpdateJson(e.updated_src);
        setDisplayLabel(true);
    }, [setDisplayLabel, setUpdateJson]);
    const checkProcessStatus = useMemo(() => processInstance.state === ProcessInstanceState.Completed || processInstance.state === ProcessInstanceState.Aborted
        ? false
        : handleVariablesChange, [handleVariablesChange, processInstance.state]);
    return (_jsxs(Card, { ...componentOuiaProps(ouiaId, "process-variables", ouiaSafe), children: [_jsxs(CardHeader, { children: [_jsx(Title, { headingLevel: "h3", size: "xl", children: "Variables" }), displayLabel && (_jsxs(Label, { color: "orange", icon: _jsx(InfoCircleIcon, {}), children: [" ", "Changes are not saved yet"] })), _jsxs(Label, { color: "green", icon: _jsx(InfoCircleIcon, {}), className: displaySuccess
                            ? "kogito-process-details--variables__label-fadeIn"
                            : "kogito-process-details--variables__label-fadeOut", children: [" ", "Changes are saved"] })] }), _jsx(CardBody, { children: _jsx(TextContent, { children: _jsx("div", { children: _jsx(ReactJson, { src: updateJson, name: false, onEdit: checkProcessStatus, onAdd: checkProcessStatus, onDelete: checkProcessStatus }) }) }) })] }));
};
export default React.memo(ProcessVariables);
//# sourceMappingURL=ProcessVariables.js.map