import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { CardBody, Card, CardHeader } from "@patternfly/react-core/dist/js/components/Card";
import { Label } from "@patternfly/react-core/dist/js/components/Label";
import { Tooltip } from "@patternfly/react-core/dist/js/components/Tooltip";
import { Title } from "@patternfly/react-core/dist/js/components/Title";
import { TextContent, TextVariants, Text } from "@patternfly/react-core/dist/js/components/Text";
import { InfoCircleIcon } from "@patternfly/react-icons/dist/js/icons/info-circle-icon";
import "../styles.css";
import { componentOuiaProps } from "@kie-tools/runtime-tools-components/dist/ouiaTools";
const ProcessDetailsMilestonesPanel = ({ ouiaId, ouiaSafe, milestones }) => {
    const handleStatus = (status) => {
        switch (status) {
            case "AVAILABLE":
                return _jsx(Label, { icon: _jsx(InfoCircleIcon, {}), children: "Available" });
            case "ACTIVE":
                return (_jsx(Label, { color: "blue", icon: _jsx(InfoCircleIcon, {}), children: "Active" }));
            case "COMPLETED":
                return (_jsx(Label, { color: "green", icon: _jsx(InfoCircleIcon, {}), children: "Completed" }));
            default:
                break;
        }
    };
    const compareObjs = (firstEle, secondEle) => {
        if (firstEle.status < secondEle.status) {
            return -1;
        }
        if (firstEle.status > secondEle.status) {
            return 1;
        }
        return 0;
    };
    const sortedMilestones = milestones === null || milestones === void 0 ? void 0 : milestones.sort(compareObjs);
    return (_jsxs(Card, { ...componentOuiaProps(ouiaId, "milestones", ouiaSafe), children: [_jsx(CardHeader, { children: _jsx(Title, { headingLevel: "h3", size: "xl", children: "Milestones" }) }), _jsx(CardBody, { children: _jsx(TextContent, { className: "kogito-process-details--milestones__nameText", children: sortedMilestones === null || sortedMilestones === void 0 ? void 0 : sortedMilestones.map((milestone, index) => {
                        if (milestone.name.length > 45) {
                            return (_jsx(Tooltip, { content: milestone.name, children: _jsxs(Text, { component: milestone.status === "COMPLETED" ? TextVariants.blockquote : TextVariants.p, children: [_jsx("span", { className: "kogito-process-details--milestones__nameTextEllipses", children: milestone.name }), " ", handleStatus(milestone.status)] }) }, index));
                        }
                        else {
                            return (_jsxs(Text, { component: milestone.status === "COMPLETED" ? TextVariants.blockquote : TextVariants.p, children: [milestone.name, " ", handleStatus(milestone.status)] }, index));
                        }
                    }) }) })] }));
};
export default ProcessDetailsMilestonesPanel;
//# sourceMappingURL=ProcessDetailsMilestonesPanel.js.map