import { jsx as _jsx, Fragment as _Fragment, jsxs as _jsxs } from "react/jsx-runtime";
import { useCallback, useEffect, useMemo, useState } from "react";
import { Flex, FlexItem } from "@patternfly/react-core/dist/js/layouts/Flex";
import { Grid, GridItem } from "@patternfly/react-core/dist/js/layouts/Grid";
import { Split, SplitItem } from "@patternfly/react-core/dist/js/layouts/Split";
import { Bullseye } from "@patternfly/react-core/dist/js/layouts/Bullseye";
import { Modal, ModalVariant } from "@patternfly/react-core/dist/js/components/Modal";
import { Button } from "@patternfly/react-core/dist/js/components/Button";
import { OverflowMenu, OverflowMenuContent, OverflowMenuGroup, } from "@patternfly/react-core/dist/js/components/OverflowMenu";
import { Card } from "@patternfly/react-core/dist/js/components/Card";
import { Title, TitleSizes } from "@patternfly/react-core/dist/js/components/Title";
import { SyncIcon } from "@patternfly/react-icons/dist/js/icons/sync-icon";
import { InfoCircleIcon } from "@patternfly/react-icons/dist/js/icons/info-circle-icon";
import ProcessDiagram from "../ProcessDiagram/ProcessDiagram";
import JobsPanel from "../JobsPanel/JobsPanel";
import ProcessDetailsErrorModal from "../ProcessDetailsErrorModal/ProcessDetailsErrorModal";
import SVG from "react-inlinesvg";
import "../styles.css";
import ProcessDetailsPanel from "../ProcessDetailsPanel/ProcessDetailsPanel";
import ProcessDetailsNodeTrigger from "../ProcessDetailsNodeTrigger/ProcessDetailsNodeTrigger";
import ProcessVariables from "../ProcessVariables/ProcessVariables";
import ProcessDetailsMilestonesPanel from "../ProcessDetailsMilestonesPanel/ProcessDetailsMilestonesPanel";
import ProcessDetailsTimelinePanel from "../ProcessDetailsTimelinePanel/ProcessDetailsTimelinePanel";
import { TitleType, } from "@kie-tools/runtime-tools-shared-gateway-api/dist/types";
import { ItemDescriptor } from "@kie-tools/runtime-tools-components/dist/components/ItemDescriptor";
import { KogitoSpinner } from "@kie-tools/runtime-tools-components/dist/components/KogitoSpinner";
import { setTitle } from "@kie-tools/runtime-tools-components/dist/utils/Utils";
import { ServerErrors } from "@kie-tools/runtime-tools-components/dist/components/ServerErrors";
import { ProcessInfoModal } from "@kie-tools/runtime-tools-components/dist/components/ProcessInfoModal";
import { ProcessInstanceState } from "@kie-tools/runtime-tools-process-gateway-api/dist/types";
const ProcessDetails = ({ isEnvelopeConnectedToChannel, driver, processDetails, omittedProcessTimelineEvents, diagramPreviewSize, showSwfDiagram, singularProcessLabel, pluralProcessLabel, }) => {
    var _a;
    const [data, setData] = useState({});
    const [jobs, setJobs] = useState([]);
    const [updateJson, setUpdateJson] = useState({});
    const [displayLabel, setDisplayLabel] = useState(false);
    const [displaySuccess, setDisplaySuccess] = useState(false);
    const [errorModalOpen, setErrorModalOpen] = useState(false);
    const [isConfirmationModalOpen, setIsConfirmationModalOpen] = useState(false);
    const [variableError, setVariableError] = useState("");
    const [svg, setSvg] = useState();
    const [svgError, setSvgError] = useState("");
    const [error, setError] = useState("");
    const [svgErrorModalOpen, setSvgErrorModalOpen] = useState(false);
    const [isLoading, setIsLoading] = useState(false);
    const [isInfoModalOpen, setIsInfoModalOpen] = useState(false);
    const [infoModalTitle, setInfoModalTitle] = useState("");
    const [titleType, setTitleType] = useState("");
    const [infoModalContent, setInfoModalContent] = useState("");
    const loadJobs = useCallback(async () => {
        const jobsResponse = await driver.jobsQuery(processDetails.id);
        jobsResponse && setJobs(jobsResponse);
    }, [processDetails.id, driver]);
    const handleReload = useCallback(async () => {
        setIsLoading(true);
        try {
            const processResponse = await driver.processDetailsQuery(processDetails.id);
            processResponse && setData(processResponse);
            loadJobs();
            setIsLoading(false);
        }
        catch (errorString) {
            setError(errorString);
            setIsLoading(false);
        }
    }, [driver, loadJobs, processDetails.id]);
    const handleSvgErrorModal = useCallback(() => {
        setSvgErrorModalOpen((currentSvgErrorModalOpen) => !currentSvgErrorModalOpen);
    }, []);
    useEffect(() => {
        const handleSvgApi = async () => {
            if (data && data.id === processDetails.id) {
                const response = await driver.getProcessDiagram(data);
                if (response && response.svg) {
                    const temp = _jsx(SVG, { src: response.svg });
                    setSvg(temp);
                }
                else if (response && response.error) {
                    setSvgError(response.error);
                }
            }
        };
        const getVariableJSON = () => {
            if (data && data.id === processDetails.id) {
                setUpdateJson(data.variables);
            }
        };
        if (isEnvelopeConnectedToChannel) {
            handleSvgApi();
            getVariableJSON();
        }
    }, [driver, data, isEnvelopeConnectedToChannel, processDetails.id]);
    useEffect(() => {
        if (svgError && svgError.length > 0 && !showSwfDiagram) {
            setSvgErrorModalOpen(true);
        }
    }, [svgError, showSwfDiagram]);
    useEffect(() => {
        if (variableError && variableError.length > 0) {
            setErrorModalOpen(true);
        }
    }, [variableError]);
    useEffect(() => {
        if (isEnvelopeConnectedToChannel) {
            setData(processDetails);
            loadJobs();
        }
    }, [isEnvelopeConnectedToChannel, loadJobs, processDetails]);
    const handleSave = useCallback(async () => {
        return driver
            .handleProcessVariableUpdate(data, updateJson)
            .then((updatedJson) => {
            setUpdateJson(updatedJson);
            setDisplayLabel(false);
            setDisplaySuccess(true);
            setTimeout(() => {
                setDisplaySuccess(false);
            }, 2000);
        })
            .catch((errorMessage) => {
            var _a;
            setVariableError((_a = errorMessage === null || errorMessage === void 0 ? void 0 : errorMessage.message) !== null && _a !== void 0 ? _a : "Failed to save process instance changes.");
        });
    }, [data, driver, updateJson]);
    const updateVariablesButton = useMemo(() => {
        if (data.serviceUrl !== null) {
            return (_jsx(Button, { variant: "secondary", id: "save-button", className: "kogito-process-details--details__buttonMargin", onClick: handleSave, isDisabled: !displayLabel, "data-testid": "save-button", children: "Save" }));
        }
        return _jsx(_Fragment, {});
    }, [data.serviceUrl, displayLabel, handleSave]);
    const handleRefresh = useCallback(() => {
        if (displayLabel) {
            setIsConfirmationModalOpen(true);
        }
        else {
            handleReload();
        }
    }, [displayLabel, handleReload]);
    const refreshButton = useMemo(() => (_jsx(Button, { variant: "plain", onClick: () => {
            handleRefresh();
        }, id: "refresh-button", "data-testid": "refresh-button", "aria-label": "Refresh list", children: _jsx(SyncIcon, {}) })), [handleRefresh]);
    const handleInfoModalToggle = useCallback(() => {
        setIsInfoModalOpen((currentValue) => !currentValue);
    }, []);
    const onAbortClick = useCallback(async (processInstance) => {
        try {
            await driver.handleProcessAbort(processInstance);
            setTitleType(TitleType.SUCCESS);
            setInfoModalTitle("Abort operation");
            setInfoModalContent(`The ${singularProcessLabel.toLowerCase()} ${processInstance.processName} was successfully aborted.`);
        }
        catch (abortError) {
            setTitleType(TitleType.FAILURE);
            setInfoModalTitle("Abort operation");
            setInfoModalContent(`Failed to abort ${singularProcessLabel.toLowerCase()} ${processInstance.processName}. Message: ${abortError.message}`);
        }
        finally {
            setIsInfoModalOpen(true);
            handleReload();
        }
    }, [driver, singularProcessLabel, handleReload]);
    const abortButton = useMemo(() => {
        if ((data.state === ProcessInstanceState.Active ||
            data.state === ProcessInstanceState.Error ||
            data.state === ProcessInstanceState.Suspended) &&
            data.addons.includes("process-management") &&
            data.serviceUrl !== null) {
            return (_jsx(Button, { variant: "secondary", id: "abort-button", "data-testid": "abort-button", onClick: () => onAbortClick(data), children: "Abort" }));
        }
        else {
            return (_jsx(Button, { variant: "secondary", isDisabled: true, children: "Abort" }));
        }
    }, [data, onAbortClick]);
    const processDiagramBlock = useMemo(() => (_jsx(Flex, { children: _jsx(FlexItem, { children: svg && svg.props.src && (_jsxs(Card, { children: [" ", _jsx(ProcessDiagram, { svg: svg, width: diagramPreviewSize === null || diagramPreviewSize === void 0 ? void 0 : diagramPreviewSize.width, height: diagramPreviewSize === null || diagramPreviewSize === void 0 ? void 0 : diagramPreviewSize.height }), " "] })) }) })), [diagramPreviewSize === null || diagramPreviewSize === void 0 ? void 0 : diagramPreviewSize.height, diagramPreviewSize === null || diagramPreviewSize === void 0 ? void 0 : diagramPreviewSize.width, svg]);
    const processTimelineBlock = useMemo(() => (_jsx(FlexItem, { children: _jsx(ProcessDetailsTimelinePanel, { data: data, jobs: jobs, driver: driver, omittedProcessTimelineEvents: omittedProcessTimelineEvents }) })), [data, driver, jobs, omittedProcessTimelineEvents]);
    const processDetailsBlock = useMemo(() => (_jsxs(Flex, { direction: { default: "column" }, flex: { default: "flex_1" }, children: [_jsx(FlexItem, { children: _jsx(ProcessDetailsPanel, { processInstance: data, driver: driver }) }), data.milestones && data.milestones.length > 0 && (_jsx(FlexItem, { children: _jsx(ProcessDetailsMilestonesPanel, { milestones: data.milestones }) }))] })), [data, driver]);
    const processVariablesBlock = useMemo(() => (_jsx(Flex, { direction: { default: "column" }, flex: { default: "flex_1" }, children: updateJson && Object.keys(updateJson).length > 0 && (_jsx(FlexItem, { children: _jsx(ProcessVariables, { displayLabel: displayLabel, displaySuccess: displaySuccess, setUpdateJson: setUpdateJson, setDisplayLabel: setDisplayLabel, updateJson: updateJson, processInstance: data }) })) })), [data, displayLabel, displaySuccess, updateJson]);
    const panels = useMemo(() => {
        if (svg && svg.props.src) {
            return (_jsxs(Flex, { direction: { default: "column" }, children: [processDiagramBlock, _jsxs(Flex, { children: [processDetailsBlock, processVariablesBlock] })] }));
        }
        else {
            return (_jsxs(_Fragment, { children: [processDetailsBlock, processVariablesBlock] }));
        }
    }, [processDetailsBlock, processVariablesBlock, processDiagramBlock, svg]);
    const handleConfirm = useCallback(() => {
        handleReload();
        setDisplayLabel(false);
        setIsConfirmationModalOpen(false);
    }, [handleReload]);
    const handleCancel = useCallback(() => {
        setVariableError("");
        handleReload();
        setIsConfirmationModalOpen(false);
    }, [handleReload]);
    const confirmationModal = useMemo(() => (_jsx(Modal, { title: "", header: _jsx(_Fragment, { children: _jsxs(Title, { headingLevel: "h1", size: TitleSizes["2xl"], children: [_jsx(InfoCircleIcon, { className: "pf-u-mr-sm", color: "var(--pf-global--warning-color--100)" }), "Refresh"] }) }), variant: ModalVariant.small, isOpen: isConfirmationModalOpen, onClose: handleCancel, actions: [
            _jsx(Button, { variant: "primary", id: "confirm-button", onClick: handleConfirm, children: "Ok" }, "Ok"),
            _jsx(Button, { variant: "link", id: "cancel-button", onClick: handleCancel, children: "Cancel" }, "Cancel"),
        ], "aria-label": "Confirmation modal", "aria-labelledby": "Confirmation modal", children: "This action discards changes made on process variables." })), [handleCancel, handleConfirm, isConfirmationModalOpen]);
    const handleErrorModal = useCallback(() => {
        setVariableError("");
        setErrorModalOpen(false);
    }, []);
    const handleRetry = useCallback(() => {
        handleErrorModal();
        handleSave();
    }, [handleSave, handleErrorModal]);
    const handleDiscard = useCallback(() => {
        handleErrorModal();
        handleRefresh();
    }, [handleRefresh, handleErrorModal]);
    const errorModal = useMemo(() => (_jsx(Modal, { title: "", header: _jsx(_Fragment, { children: _jsxs(Title, { headingLevel: "h1", size: TitleSizes["2xl"], children: [_jsx(InfoCircleIcon, { className: "pf-u-mr-sm", color: "var(--pf-global--danger-color--100)" }), "Error"] }) }), variant: ModalVariant.small, isOpen: errorModalOpen, onClose: handleErrorModal, actions: [
            _jsx(Button, { variant: "primary", id: "retry-button", onClick: handleRetry, children: "Retry" }, "Retry"),
            _jsx(Button, { variant: "link", id: "discard-button", onClick: handleDiscard, children: "Discard" }, "Discard"),
        ], "aria-label": "Error modal", "aria-labelledby": "Error modal", children: variableError })), [errorModalOpen, handleDiscard, handleErrorModal, handleRetry, variableError]);
    return (_jsxs(_Fragment, { children: [!error ? (_jsxs(_Fragment, { children: [!isLoading && Object.keys(data).length > 0 ? (_jsxs(_Fragment, { children: [_jsx(Grid, { hasGutter: true, md: 1, span: 12, lg: 6, xl: 4, children: _jsx(GridItem, { span: 12, children: _jsxs(Split, { hasGutter: true, component: "div", className: "pf-u-align-items-center", children: [_jsx(SplitItem, { isFilled: true, children: _jsx(Title, { headingLevel: "h2", size: "4xl", className: "kogito-process-details--details__title", children: _jsx(ItemDescriptor, { itemDescription: {
                                                            id: data.id,
                                                            name: data.processName,
                                                            description: data.businessKey,
                                                        } }) }) }), _jsx(SplitItem, { children: _jsx(OverflowMenu, { breakpoint: "lg", children: _jsx(OverflowMenuContent, { isPersistent: true, children: _jsx(OverflowMenuGroup, { groupType: "button", isPersistent: true, children: _jsxs(_Fragment, { children: [updateVariablesButton, abortButton, refreshButton] }) }) }) }) })] }) }) }), _jsxs(Flex, { direction: { default: "column", lg: "row" }, className: "kogito-process-details--details__marginSpaces", children: [panels, _jsxs(Flex, { direction: { default: "column" }, flex: { default: "flex_1" }, children: [processTimelineBlock, _jsx(FlexItem, { children: _jsx(JobsPanel, { jobs: jobs, driver: driver }) }), ((_a = data.addons) === null || _a === void 0 ? void 0 : _a.includes("process-management")) &&
                                                data.state !== ProcessInstanceState.Completed &&
                                                data.state !== ProcessInstanceState.Aborted &&
                                                data.serviceUrl &&
                                                data.addons.includes("process-management") && (_jsx(FlexItem, { children: _jsx(ProcessDetailsNodeTrigger, { driver: driver, processInstanceData: data }) }))] }), errorModal, confirmationModal] })] })) : (_jsx(Card, { children: _jsx(KogitoSpinner, { spinnerText: "Loading process details..." }) })), svgErrorModalOpen && (_jsx(ProcessDetailsErrorModal, { errorString: svgError, errorModalOpen: svgErrorModalOpen, errorModalAction: [
                            _jsx(Button, { "data-testid": "svg-error-modal", variant: "primary", onClick: handleSvgErrorModal, children: "OK" }, "confirm-selection"),
                        ], handleErrorModal: handleSvgErrorModal, label: "svg error modal", title: setTitle("failure", "Process Diagram") }))] })) : (_jsx(_Fragment, { children: isEnvelopeConnectedToChannel && (_jsx(Card, { className: "kogito-process-details__card-size", children: _jsx(Bullseye, { children: _jsx(ServerErrors, { error: error, variant: "large" }) }) })) })), _jsx(ProcessInfoModal, { isModalOpen: isInfoModalOpen, handleModalToggle: handleInfoModalToggle, modalTitle: setTitle(titleType, infoModalTitle), modalContent: infoModalContent, processName: data && data.processName })] }));
};
export default ProcessDetails;
//# sourceMappingURL=ProcessDetails.js.map