import { jsx as _jsx } from "react/jsx-runtime";
import { TextContent, Text } from "@patternfly/react-core/dist/js/components/Text";
import { Modal } from "@patternfly/react-core/dist/js/components/Modal";
import { Button } from "@patternfly/react-core/dist/js/components/Button";
import { BulkList } from "@kie-tools/runtime-tools-components/dist/components/BulkList";
import { componentOuiaProps } from "@kie-tools/runtime-tools-components/dist/ouiaTools";
export const JobsCancelModal = ({ actionType, modalContent, modalTitle, isModalOpen, handleModalToggle, jobOperations, ouiaId, ouiaSafe, }) => {
    return (_jsx(Modal, { variant: "small", title: "", header: modalTitle, isOpen: isModalOpen, onClose: handleModalToggle, "aria-label": `${actionType} Modal`, "aria-labelledby": `${actionType} Modal`, actions: [
            _jsx(Button, { variant: "primary", onClick: handleModalToggle, children: "OK" }, "confirm-selection"),
        ], ...componentOuiaProps(ouiaId, "jobs-cancel-modal", ouiaSafe), children: modalContent.length > 0 ? (_jsx(TextContent, { children: _jsx(Text, { children: modalContent }) })) : (_jsx(BulkList, { operationResult: jobOperations })) }));
};
//# sourceMappingURL=JobsCancelModal.js.map