import { jsx as _jsx } from "react/jsx-runtime";
import React, { useCallback, useMemo } from "react";
import { RefForwardingEmbeddedEnvelope } from "@kie-tools-core/envelope/dist/embedded";
import { ContainerType } from "@kie-tools-core/envelope/dist/api";
import { init } from "../envelope";
import { JobsManagementChannelApiImpl } from "./JobsManagementChannelApiImpl";
export const EmbeddedJobsManagement = React.forwardRef((props, forwardedRef) => {
    const refDelegate = useCallback((envelopeServer) => ({}), []);
    const pollInit = useCallback(async (envelopeServer, container) => {
        await init({
            config: {
                containerType: ContainerType.DIV,
                envelopeId: envelopeServer.id,
            },
            container: container(),
            bus: {
                postMessage(message, targetOrigin, transfer) {
                    window.postMessage(message, targetOrigin, transfer);
                },
            },
        });
        return await envelopeServer.envelopeApi.requests.jobsManagement__init({
            origin: envelopeServer.origin,
            envelopeServerId: envelopeServer.id,
        }, props.initialState
            ? {
                initialState: props.initialState,
            }
            : {});
    }, [props.initialState]);
    const apiImpl = useMemo(() => new JobsManagementChannelApiImpl(props.driver), [props.driver]);
    return (_jsx(EmbeddedJobsManagementEnvelope, { ref: forwardedRef, apiImpl: apiImpl, origin: props.targetOrigin, refDelegate: refDelegate, pollInit: pollInit, config: { containerType: ContainerType.DIV } }));
});
const EmbeddedJobsManagementEnvelope = React.forwardRef(RefForwardingEmbeddedEnvelope);
//# sourceMappingURL=EmbeddedJobsManagement.js.map