"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GwtStateControlService = void 0;
var DefaultStateControlCommandRegistry_1 = require("./DefaultStateControlCommandRegistry");
var GwtStateControlService = (function () {
    function GwtStateControlService() {
    }
    GwtStateControlService.prototype.undo = function () {
        if (this.undoCommand) {
            this.undoCommand();
        }
    };
    GwtStateControlService.prototype.redo = function () {
        if (this.redoCommand) {
            this.redoCommand();
        }
    };
    GwtStateControlService.prototype.getExposedInteropApi = function (channelApi) {
        var _this = this;
        return {
            registry: new DefaultStateControlCommandRegistry_1.DefaultStateControlCommandRegistry(channelApi),
            setUndoCommand: function (undoCommand) { return (_this.undoCommand = undoCommand); },
            setRedoCommand: function (redoCommand) { return (_this.redoCommand = redoCommand); },
        };
    };
    return GwtStateControlService;
}());
exports.GwtStateControlService = GwtStateControlService;
//# sourceMappingURL=GwtStateControlService.js.map