import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import React from "react";
import { TextContent, Text } from "@patternfly/react-core/dist/js/components/Text";
import { Modal } from "@patternfly/react-core/dist/js/components/Modal";
import { Button } from "@patternfly/react-core/dist/js/components/Button";
import { componentOuiaProps } from "../../ouiaTools";
import { BulkList } from "../BulkList";
export const WorkflowInfoModal = ({ modalContent, modalTitle, isModalOpen, handleModalToggle, resetSelected, operationResult, workflowName, ouiaId, ouiaSafe, }) => {
    const onOkClick = () => {
        handleModalToggle();
        operationResult && resetSelected && resetSelected();
    };
    const createBoldText = (text, shouldBeBold) => {
        if (text && shouldBeBold && shouldBeBold.length > 0) {
            const textArray = text.split(shouldBeBold);
            return (_jsx("span", { children: textArray.map((item, index) => (_jsxs(React.Fragment, { children: [item, index !== textArray.length - 1 && _jsx("b", { children: shouldBeBold })] }, index))) }));
        }
        else {
            return _jsx("span", { children: text });
        }
    };
    return (_jsxs(Modal, { variant: "small", title: "", header: modalTitle, isOpen: isModalOpen, onClose: onOkClick, "aria-label": "workflow list modal", "aria-labelledby": "workflow list modal", actions: [
            _jsx(Button, { variant: "primary", onClick: onOkClick, children: "OK" }, "confirm-selection"),
        ], ...componentOuiaProps(ouiaId, "workflow-list-modal", ouiaSafe), children: [operationResult !== undefined && _jsx(BulkList, { operationResult: operationResult }), _jsx(TextContent, { children: _jsx(Text, { children: createBoldText(modalContent, workflowName) }) })] }));
};
//# sourceMappingURL=WorkflowInfoModal.js.map