import { EditorTheme } from "@kie-tools-core/editor/dist/api";
import { editor } from "monaco-editor";
export interface RequestDataEditorApi {
    editor: editor.IStandaloneCodeEditor | undefined;
    show: (container: HTMLDivElement, theme?: EditorTheme) => editor.IStandaloneCodeEditor;
    undo: () => void;
    redo: () => void;
    getContent: () => string;
    setContent: (content: string) => void;
    setTheme: (theme: EditorTheme) => void;
    forceRedraw: () => void;
    dispose: () => void;
}
export declare enum RequestDataEditorOperation {
    UNDO = 0,
    REDO = 1,
    EDIT = 2
}
export interface RequestDataEditorInstance {
    instance: editor.IStandaloneCodeEditor;
}
export declare class RequestDataEditorController implements RequestDataEditorApi {
    private readonly onContentChange;
    private readonly isReadOnly;
    private readonly model;
    editor: editor.IStandaloneCodeEditor | undefined;
    constructor(content: string, onContentChange: (args: {
        content: string;
        operation: RequestDataEditorOperation;
    }) => void, isReadOnly: boolean);
    redo(): void;
    undo(): void;
    setTheme(theme: EditorTheme): void;
    show(container: HTMLDivElement, theme: EditorTheme): editor.IStandaloneCodeEditor;
    getContent(): string;
    setContent(content: string): void;
    forceRedraw(): void;
    private getMonacoThemeByEditorTheme;
    dispose(): void;
}
//# sourceMappingURL=RequestDataEditorController.d.ts.map