import { jsx as _jsx, jsxs as _jsxs, Fragment as _Fragment } from "react/jsx-runtime";
import { TextContent, Text, TextVariants } from "@patternfly/react-core/dist/js/components/Text";
import { Tooltip } from "@patternfly/react-core/dist/js/components/Tooltip";
import { Badge } from "@patternfly/react-core/dist/js/components/Badge";
import { componentOuiaProps } from "../../ouiaTools";
export const ItemDescriptor = ({ itemDescription, ouiaId, ouiaSafe }) => {
    const tooltipContainerId = `kogito-consoles-tooltip-${itemDescription.id}-${Math.random()}`;
    const idStringModifier = (strId) => {
        return (_jsx(TextContent, { className: "pf-u-display-inline", children: _jsx(Text, { component: TextVariants.small, className: "pf-u-display-inline", children: strId.substring(0, 5) }) }));
    };
    return (_jsxs(_Fragment, { children: [_jsx(Tooltip, { appendTo: () => document.getElementById(tooltipContainerId), content: itemDescription.id, ...componentOuiaProps(ouiaId, "item-descriptor", ouiaSafe), children: _jsxs("span", { children: [itemDescription.name, " ", itemDescription.description ? (_jsx(Badge, { children: itemDescription.description })) : (idStringModifier(itemDescription.id))] }) }), _jsx("div", { id: tooltipContainerId })] }));
};
//# sourceMappingURL=ItemDescriptor.js.map