import { jsx as _jsx, jsxs as _jsxs, Fragment as _Fragment } from "react/jsx-runtime";
import { TextContent, TextVariants, Text, TextList, TextListItem, } from "@patternfly/react-core/dist/js/components/Text";
import { Divider } from "@patternfly/react-core/dist/js/components/Divider";
import { ItemDescriptor } from "../ItemDescriptor";
import { componentOuiaProps } from "../../ouiaTools";
export var BulkListType;
(function (BulkListType) {
    BulkListType["PROCESS_INSTANCE"] = "process_instance";
    BulkListType["JOB"] = "job";
    BulkListType["WORKFLOW"] = "workflow";
})(BulkListType || (BulkListType = {}));
export const BulkList = ({ operationResult, ouiaId, ouiaSafe }) => {
    const iterateItems = (itemList) => {
        return (_jsx(TextList, { children: itemList.map((item) => {
                return (_jsxs(TextListItem, { children: [_jsx("strong", { children: _jsx(ItemDescriptor, { itemDescription: item }) }), " ", item.errorMessage && _jsxs("span", { children: [" - ", item.errorMessage] })] }, item.id));
            }) }));
    };
    return (_jsxs("div", { ...componentOuiaProps(ouiaId, "bulk-list", ouiaSafe), children: [operationResult.results.successItems.length > 0 ? (_jsxs(_Fragment, { children: [_jsxs(TextContent, { children: [_jsx(Text, { component: TextVariants.h2, children: operationResult.messages.successMessage }), iterateItems(operationResult.results.successItems)] }), operationResult.results.successItems.length !== 0 && operationResult.messages.warningMessage && (_jsx(TextContent, { className: "pf-u-mt-sm", children: _jsx(Text, { component: TextVariants.small, children: operationResult.messages.warningMessage }) }))] })) : (_jsx(TextContent, { children: _jsx(Text, { component: TextVariants.h2, children: operationResult.messages.noItemsMessage }) })), operationResult.results.ignoredItems.length !== 0 && (_jsxs(_Fragment, { children: [_jsx(Divider, { component: "div", className: "pf-u-my-xl" }), _jsxs(TextContent, { children: [_jsxs(Text, { component: TextVariants.h2, children: [operationResult.type === BulkListType.PROCESS_INSTANCE && _jsx("span", { children: "Ignored process instances:" }), operationResult.type === BulkListType.WORKFLOW && _jsx("span", { children: "Ignored workflows:" }), operationResult.type === BulkListType.JOB && _jsx("span", { children: "Ignored jobs:" })] }), _jsx(Text, { component: TextVariants.small, className: "pf-u-mt-sm", children: _jsx("span", { children: operationResult.messages.ignoredMessage }) }), iterateItems(operationResult.results.ignoredItems)] })] })), operationResult.results.failedItems.length !== 0 && (_jsxs(_Fragment, { children: [_jsx(Divider, { component: "div", className: "pf-u-my-xl" }), _jsxs(TextContent, { children: [_jsx(Text, { component: TextVariants.h2, children: "Errors:" }), iterateItems(operationResult.results.failedItems)] })] }))] }));
};
//# sourceMappingURL=BulkList.js.map