import { jsx as _jsx } from "react/jsx-runtime";
import { useCallback } from "react";
import { DEFAULT_WORKSPACE_ROOT_ABSOLUTE_POSIX_PATH, } from "@kie-tools-core/editor/dist/api";
import { ResourcesList } from "@kie-tools-core/workspace/dist/api";
import { TestScenarioEditorRoot } from "./TestScenarioEditorRoot";
export class TestScenarioEditorFactory {
    createEditor(envelopeContext, initArgs) {
        return Promise.resolve(new TestScenarioEditorInterface(envelopeContext, initArgs));
    }
}
export class TestScenarioEditorInterface {
    constructor(envelopeContext, initArgs) {
        this.envelopeContext = envelopeContext;
        this.initArgs = initArgs;
        this.af_isReact = true;
    }
    getPreview() {
        return this.self.getDiagramSvg();
    }
    async validate() {
        return Promise.resolve([]);
    }
    async setTheme(theme) {
        return Promise.resolve();
    }
    async undo() {
        return this.self.undo();
    }
    async redo() {
        return this.self.redo();
    }
    getContent() {
        return this.self.getContent();
    }
    setContent(normalizedPosixPathRelativeToTheWorkspaceRoot, content) {
        return this.self.setContent(normalizedPosixPathRelativeToTheWorkspaceRoot, content);
    }
    af_componentRoot() {
        var _a;
        return (_jsx(TestScenarioEditorRootWrapper, { exposing: (testScenarioEditorRoot) => (this.self = testScenarioEditorRoot), envelopeContext: this.envelopeContext, workspaceRootAbsolutePosixPath: (_a = this.initArgs.workspaceRootAbsolutePosixPath) !== null && _a !== void 0 ? _a : DEFAULT_WORKSPACE_ROOT_ABSOLUTE_POSIX_PATH, isReadOnly: this.initArgs.isReadOnly }));
    }
}
function TestScenarioEditorRootWrapper({ envelopeContext, exposing, workspaceRootAbsolutePosixPath, isReadOnly, }) {
    const onNewEdit = useCallback((workspaceEdit) => {
        envelopeContext === null || envelopeContext === void 0 ? void 0 : envelopeContext.channelApi.notifications.kogitoWorkspace_newEdit.send(workspaceEdit);
    }, [envelopeContext]);
    const onRequestWorkspaceFilesList = useCallback(async (resource) => {
        var _a;
        return ((_a = envelopeContext === null || envelopeContext === void 0 ? void 0 : envelopeContext.channelApi.requests.kogitoWorkspace_resourceListRequest(resource)) !== null && _a !== void 0 ? _a : new ResourcesList("", []));
    }, [envelopeContext]);
    const onRequestWorkspaceFileContent = useCallback(async (resource) => {
        return envelopeContext === null || envelopeContext === void 0 ? void 0 : envelopeContext.channelApi.requests.kogitoWorkspace_resourceContentRequest(resource);
    }, [envelopeContext]);
    const onOpenFileFromNormalizedPosixPathRelativeToTheWorkspaceRoot = useCallback((normalizedPosixPathRelativeToTheWorkspaceRoot) => {
        envelopeContext === null || envelopeContext === void 0 ? void 0 : envelopeContext.channelApi.notifications.kogitoWorkspace_openFile.send(normalizedPosixPathRelativeToTheWorkspaceRoot);
    }, [envelopeContext]);
    return (_jsx(TestScenarioEditorRoot, { exposing: exposing, onNewEdit: onNewEdit, onRequestWorkspaceFilesList: onRequestWorkspaceFilesList, onRequestWorkspaceFileContent: onRequestWorkspaceFileContent, onOpenFileFromNormalizedPosixPathRelativeToTheWorkspaceRoot: onOpenFileFromNormalizedPosixPathRelativeToTheWorkspaceRoot, workspaceRootAbsolutePosixPath: workspaceRootAbsolutePosixPath, keyboardShortcutsService: envelopeContext === null || envelopeContext === void 0 ? void 0 : envelopeContext.services.keyboardShortcuts, isReadOnly: isReadOnly }));
}
//# sourceMappingURL=TestScenarioEditorFactory.js.map